/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * MEEP Demo 4 API
 * Demo 4 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC016 usage
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * API version: 0.0.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

import (
	"context"
	"net/http"
)

// FrontendApiRouter defines the required methods for binding the api requests to a responses for the FrontendApi
// The FrontendApiRouter implementation should parse necessary information from the http request,
// pass the data to a FrontendApiServicer to perform the required actions, then write the service results to the http response.
type FrontendApiRouter interface {
	Ping(http.ResponseWriter, *http.Request)
	Terminate(http.ResponseWriter, *http.Request)
}

// FrontendApiServicer defines the api actions for the FrontendApi service
// This interface intended to stay up to date with the openapi yaml used to generate it,
// while the service implementation can ignored with the .openapi-generator-ignore file
// and updated with the logic required for the API.
type FrontendApiServicer interface {
	Ping(context.Context) (interface{}, error)
	Terminate(context.Context) (interface{}, error)
}
