/*
 * Copyright (c) 2024  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE V2X Information Service REST API
 *
 * V2X Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC030 V2XI API](.https://www.etsi.org/deliver/etsi_gs/MEC/001_099/030/03.02.01_60/) ETSI 2024](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-vis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-vis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Note**<br>AdvantEDGE supports a selected subset of VIS API endpoints (see below) and a subset of subscription types.
 *
 * API version: 3.2.2
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

type SubscriptionCommon struct {
	Links *Links `json:"_links,omitempty"`
	// URI selected by the service consumer, to receive notifications on the subscribed RNIS information. This shall be included in the request and response.
	SubscriptionType        string              `json:"subscriptionType"`
	RequestTestNotification bool                `json:"requestTestNotification"`
	CallbackReference       string              `json:"callbackReference"`
	WebsockNotifConfig      *WebsockNotifConfig `json:"websockNotifConfig,omitempty"`
	ExpiryDeadline          *TimeStamp          `json:"expiryDeadline,omitempty"`
}
