# Go API client for swagger

The MEC Sandbox API described using OpenAPI

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 0.0.9
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/sandbox-api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthorizationApi* | [**Login**](docs/AuthorizationApi.md#login) | **Post** /login | Initiate OAuth login procedure and creates a MEC Sandbox instance
*AuthorizationApi* | [**Logout**](docs/AuthorizationApi.md#logout) | **Post** /logout | Terminates User Session and delete the Sandbox instance
*SandboxAppInstancesApi* | [**SandboxAppInstancesDELETE**](docs/SandboxAppInstancesApi.md#sandboxappinstancesdelete) | **Delete** /sandboxAppInstances/{app_instance_id} | Delete an existing application instance
*SandboxAppInstancesApi* | [**SandboxAppInstancesGET**](docs/SandboxAppInstancesApi.md#sandboxappinstancesget) | **Get** /sandboxAppInstances | Get the list of the available application instance identifiers
*SandboxAppInstancesApi* | [**SandboxAppInstancesPOST**](docs/SandboxAppInstancesApi.md#sandboxappinstancespost) | **Post** /sandboxAppInstances | Create a new application instance identifier
*SandboxLogsSubscriptionsApi* | [**SandboxLogsSubscriptionsDELETE**](docs/SandboxLogsSubscriptionsApi.md#sandboxlogssubscriptionsdelete) | **Delete** /sandboxLogsSubscriptions/{subscription_reference} | Subscription to receive logs from the sandbox
*SandboxLogsSubscriptionsApi* | [**SandboxLogsSubscriptionsPOST**](docs/SandboxLogsSubscriptionsApi.md#sandboxlogssubscriptionspost) | **Post** /sandboxLogsSubscriptions | Subscription to receive logs from the sandbox
*SandboxMECServicesApi* | [**SandboxMecServicesGET**](docs/SandboxMECServicesApi.md#sandboxmecservicesget) | **Get** /sandboxMecServices | Get the list of the available MEC services
*SandboxNetworkScenariosApi* | [**SandboxIndividualNetworkScenariosGET**](docs/SandboxNetworkScenariosApi.md#sandboxindividualnetworkscenariosget) | **Get** /sandboxNetworkScenarios/{network_scenario_id} | Get description of a Network Scenario to be used.
*SandboxNetworkScenariosApi* | [**SandboxNetworkScenarioDELETE**](docs/SandboxNetworkScenariosApi.md#sandboxnetworkscenariodelete) | **Delete** /sandboxNetworkScenarios/{network_scenario_id} | Deactivate the Network Scenario.
*SandboxNetworkScenariosApi* | [**SandboxNetworkScenarioPOST**](docs/SandboxNetworkScenariosApi.md#sandboxnetworkscenariopost) | **Post** /sandboxNetworkScenarios/{network_scenario_id} | Selects the Network Scenario to be used.
*SandboxNetworkScenariosApi* | [**SandboxNetworkScenariosGET**](docs/SandboxNetworkScenariosApi.md#sandboxnetworkscenariosget) | **Get** /sandboxNetworkScenarios | Get the list of the available network scenarios
*SandboxUEControllerApi* | [**SandboxUeControllerGET**](docs/SandboxUEControllerApi.md#sandboxuecontrollerget) | **Get** /sandboxUeController | Get the list of the available UEs (e.g. \&quot;Stationary UE\&quot;)
*SandboxUEControllerApi* | [**SandboxUeControllerPATCH**](docs/SandboxUEControllerApi.md#sandboxuecontrollerpatch) | **Patch** /sandboxUeController/{user_equipment_id}/{user_equipment_value} | set the new value of the UE

## Documentation For Models

 - [ApplicationInfo](docs/ApplicationInfo.md)
 - [CellularDomainConfig](docs/CellularDomainConfig.md)
 - [CellularPoaConfig](docs/CellularPoaConfig.md)
 - [ConnectivityConfig](docs/ConnectivityConfig.md)
 - [CpuConfig](docs/CpuConfig.md)
 - [D2dConfig](docs/D2dConfig.md)
 - [Deployment](docs/Deployment.md)
 - [DnConfig](docs/DnConfig.md)
 - [Domain](docs/Domain.md)
 - [EgressService](docs/EgressService.md)
 - [ExternalConfig](docs/ExternalConfig.md)
 - [GeoData](docs/GeoData.md)
 - [GpuConfig](docs/GpuConfig.md)
 - [IngressService](docs/IngressService.md)
 - [LineString](docs/LineString.md)
 - [MemoryConfig](docs/MemoryConfig.md)
 - [NetworkCharacteristics](docs/NetworkCharacteristics.md)
 - [NetworkLocation](docs/NetworkLocation.md)
 - [PhysicalLocation](docs/PhysicalLocation.md)
 - [Poa4GConfig](docs/Poa4GConfig.md)
 - [Poa5GConfig](docs/Poa5GConfig.md)
 - [PoaWifiConfig](docs/PoaWifiConfig.md)
 - [Point](docs/Point.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [Process](docs/Process.md)
 - [Sandbox](docs/Sandbox.md)
 - [SandboxAppInstances](docs/SandboxAppInstances.md)
 - [SandboxLogsSubscriptions](docs/SandboxLogsSubscriptions.md)
 - [SandboxMecServices](docs/SandboxMecServices.md)
 - [SandboxNetworkScenario](docs/SandboxNetworkScenario.md)
 - [Scenario](docs/Scenario.md)
 - [ScenarioConfig](docs/ScenarioConfig.md)
 - [ServiceConfig](docs/ServiceConfig.md)
 - [ServicePort](docs/ServicePort.md)
 - [Ue](docs/Ue.md)
 - [Zone](docs/Zone.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

cti_support@etsi.org
