/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Sandbox Controller REST API
 * This API is the main Sandbox Controller API for scenario deployment & event injection <p>**Micro-service**<br>[meep-sandbox-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-sandbox-ctrl) <p>**Type & Usage**<br>Platform runtime interface to manage active scenarios and inject events in AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/NodeDataUnion'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./NodeDataUnion'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeSandboxControllerRestApi) {
      root.AdvantEdgeSandboxControllerRestApi = {};
    }
    root.AdvantEdgeSandboxControllerRestApi.ScenarioNode = factory(root.AdvantEdgeSandboxControllerRestApi.ApiClient, root.AdvantEdgeSandboxControllerRestApi.NodeDataUnion);
  }
}(this, function(ApiClient, NodeDataUnion) {
  'use strict';

  /**
   * The ScenarioNode model module.
   * @module model/ScenarioNode
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>ScenarioNode</code>.
   * Scenario node object
   * @alias module:model/ScenarioNode
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>ScenarioNode</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/ScenarioNode} obj Optional instance to populate.
   * @return {module:model/ScenarioNode} The populated <code>ScenarioNode</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('type'))
        obj.type = ApiClient.convertToType(data['type'], 'String');
      if (data.hasOwnProperty('nodeDataUnion'))
        obj.nodeDataUnion = NodeDataUnion.constructFromObject(data['nodeDataUnion']);
      if (data.hasOwnProperty('parent'))
        obj.parent = ApiClient.convertToType(data['parent'], 'String');
      if (data.hasOwnProperty('children'))
        obj.children = ApiClient.convertToType(data['children'], ['String']);
    }
    return obj;
  }

  /**
   * Node type
   * @member {module:model/ScenarioNode.TypeEnum} type
   */
  exports.prototype.type = undefined;

  /**
   * @member {module:model/NodeDataUnion} nodeDataUnion
   */
  exports.prototype.nodeDataUnion = undefined;

  /**
   * Parent node name
   * @member {String} parent
   */
  exports.prototype.parent = undefined;

  /**
   * List of child node names
   * @member {Array.<String>} children
   */
  exports.prototype.children = undefined;


  /**
   * Allowed values for the <code>type</code> property.
   * @enum {String}
   * @readonly
   */
  exports.TypeEnum = {
    /**
     * value: "UE"
     * @const
     */
    UE: "UE",

    /**
     * value: "FOG"
     * @const
     */
    FOG: "FOG",

    /**
     * value: "EDGE"
     * @const
     */
    EDGE: "EDGE",

    /**
     * value: "UE-APP"
     * @const
     */
    UE_APP: "UE-APP",

    /**
     * value: "EDGE-APP"
     * @const
     */
    EDGE_APP: "EDGE-APP",

    /**
     * value: "CLOUD-APP"
     * @const
     */
    CLOUD_APP: "CLOUD-APP"
  };

  return exports;

}));
