/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Sandbox Controller REST API
 * This API is the main Sandbox Controller API for scenario deployment & event injection <p>**Micro-service**<br>[meep-sandbox-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-sandbox-ctrl) <p>**Type & Usage**<br>Platform runtime interface to manage active scenarios and inject events in AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/PDUSessionInfo', 'model/PDUSessionList'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../model/PDUSessionInfo'), require('../model/PDUSessionList'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeSandboxControllerRestApi) {
      root.AdvantEdgeSandboxControllerRestApi = {};
    }
    root.AdvantEdgeSandboxControllerRestApi.ConnectivityApi = factory(root.AdvantEdgeSandboxControllerRestApi.ApiClient, root.AdvantEdgeSandboxControllerRestApi.PDUSessionInfo, root.AdvantEdgeSandboxControllerRestApi.PDUSessionList);
  }
}(this, function(ApiClient, PDUSessionInfo, PDUSessionList) {
  'use strict';

  /**
   * Connectivity service.
   * @module api/ConnectivityApi
   * @version 1.0.0
   */

  /**
   * Constructs a new ConnectivityApi. 
   * @alias module:api/ConnectivityApi
   * @class
   * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
   * default to {@link module:ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the createPduSession operation.
     * @callback module:api/ConnectivityApi~createPduSessionCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a PDU Session
     * Establish a PDU Session to a Data Network defined in the scenario
     * @param {String} ueName UE unique identifier from the scenario
     * @param {String} pduSessionId a UE provided identifier for the PDU Session
     * @param {module:model/PDUSessionInfo} pduSessionInfo PDU session information
     * @param {module:api/ConnectivityApi~createPduSessionCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.createPduSession = function(ueName, pduSessionId, pduSessionInfo, callback) {
      var postBody = pduSessionInfo;

      // verify the required parameter 'ueName' is set
      if (ueName === undefined || ueName === null) {
        throw new Error("Missing the required parameter 'ueName' when calling createPduSession");
      }

      // verify the required parameter 'pduSessionId' is set
      if (pduSessionId === undefined || pduSessionId === null) {
        throw new Error("Missing the required parameter 'pduSessionId' when calling createPduSession");
      }

      // verify the required parameter 'pduSessionInfo' is set
      if (pduSessionInfo === undefined || pduSessionInfo === null) {
        throw new Error("Missing the required parameter 'pduSessionInfo' when calling createPduSession");
      }


      var pathParams = {
        'ueName': ueName,
        'pduSessionId': pduSessionId
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;

      return this.apiClient.callApi(
        '/connectivity/pdu-session/{ueName}/{pduSessionId}', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getPduSessionList operation.
     * @callback module:api/ConnectivityApi~getPduSessionListCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PDUSessionList} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get list of PDU Sessions
     * Get list of active PDU Sessions matching provided filters
     * @param {Object} opts Optional parameters
     * @param {String} opts.ue Return PDU sessions matching provided UE name
     * @param {String} opts.id Return PDU session matching provided PDU session ID
     * @param {module:api/ConnectivityApi~getPduSessionListCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PDUSessionList}
     */
    this.getPduSessionList = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'ue': opts['ue'],
        'id': opts['id'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = PDUSessionList;

      return this.apiClient.callApi(
        '/connectivity/pdu-session', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the terminatePduSession operation.
     * @callback module:api/ConnectivityApi~terminatePduSessionCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Terminate a PDU Session
     * Terminate a PDU session to a Data Network defined in the scenario
     * @param {String} ueName UE unique identifier from the scenario
     * @param {String} pduSessionId a UE provided identifier for the PDU Session
     * @param {module:api/ConnectivityApi~terminatePduSessionCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.terminatePduSession = function(ueName, pduSessionId, callback) {
      var postBody = null;

      // verify the required parameter 'ueName' is set
      if (ueName === undefined || ueName === null) {
        throw new Error("Missing the required parameter 'ueName' when calling terminatePduSession");
      }

      // verify the required parameter 'pduSessionId' is set
      if (pduSessionId === undefined || pduSessionId === null) {
        throw new Error("Missing the required parameter 'pduSessionId' when calling terminatePduSession");
      }


      var pathParams = {
        'ueName': ueName,
        'pduSessionId': pduSessionId
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;

      return this.apiClient.callApi(
        '/connectivity/pdu-session/{ueName}/{pduSessionId}', 'DELETE',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
