/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Metrics Service REST API
 * Metrics Service provides metrics about the active scenario <p>**Micro-service**<br>[meep-metrics-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-metrics-engine) <p>**Type & Usage**<br>Platform Service used by control/monitoring software and possibly by edge applications that require metrics <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/Scope', 'model/Tag'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./Scope'), require('./Tag'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeMetricsServiceRestApi) {
      root.AdvantEdgeMetricsServiceRestApi = {};
    }
    root.AdvantEdgeMetricsServiceRestApi.SeqQueryParams = factory(root.AdvantEdgeMetricsServiceRestApi.ApiClient, root.AdvantEdgeMetricsServiceRestApi.Scope, root.AdvantEdgeMetricsServiceRestApi.Tag);
  }
}(this, function(ApiClient, Scope, Tag) {
  'use strict';

  /**
   * The SeqQueryParams model module.
   * @module model/SeqQueryParams
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>SeqQueryParams</code>.
   * Seq metrics query parameters
   * @alias module:model/SeqQueryParams
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>SeqQueryParams</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/SeqQueryParams} obj Optional instance to populate.
   * @return {module:model/SeqQueryParams} The populated <code>SeqQueryParams</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('tags'))
        obj.tags = ApiClient.convertToType(data['tags'], [Tag]);
      if (data.hasOwnProperty('fields'))
        obj.fields = ApiClient.convertToType(data['fields'], ['String']);
      if (data.hasOwnProperty('responseType'))
        obj.responseType = ApiClient.convertToType(data['responseType'], 'String');
      if (data.hasOwnProperty('scope'))
        obj.scope = Scope.constructFromObject(data['scope']);
    }
    return obj;
  }

  /**
   * Tag names to match in query. Supported values:<br> 
   * @member {Array.<module:model/Tag>} tags
   */
  exports.prototype.tags = undefined;

  /**
   * Requested information. Supported values:<br> NOTE: only one of mermaid or sdorg must be included  <li>mermaid: Mermaid format<br> <li>sdorg: Sequencediagram.org format<br> 
   * @member {Array.<module:model/SeqQueryParams.FieldsEnum>} fields
   */
  exports.prototype.fields = undefined;

  /**
   * Queried response Type. Supported Values:<br> NOTE1: only one of listonly or responly may be included  NOTE2: if listonly or responly are not included, the response contains both the list and string  <li>listonly: Include only a list of sequence metrics in response<br> <li>stronly: Include only a concatenated string of sequence metrics in response<br> 
   * @member {module:model/SeqQueryParams.ResponseTypeEnum} responseType
   */
  exports.prototype.responseType = undefined;

  /**
   * @member {module:model/Scope} scope
   */
  exports.prototype.scope = undefined;


  /**
   * Allowed values for the <code>fields</code> property.
   * @enum {String}
   * @readonly
   */
  exports.FieldsEnum = {
    /**
     * value: "mermaid"
     * @const
     */
    mermaid: "mermaid",

    /**
     * value: "sdorg"
     * @const
     */
    sdorg: "sdorg"
  };


  /**
   * Allowed values for the <code>responseType</code> property.
   * @enum {String}
   * @readonly
   */
  exports.ResponseTypeEnum = {
    /**
     * value: "listonly"
     * @const
     */
    listonly: "listonly",

    /**
     * value: "stronly"
     * @const
     */
    stronly: "stronly"
  };

  return exports;

}));
