/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Metrics Service REST API
 * Metrics Service provides metrics about the active scenario <p>**Micro-service**<br>[meep-metrics-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-metrics-engine) <p>**Type & Usage**<br>Platform Service used by control/monitoring software and possibly by edge applications that require metrics <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeMetricsServiceRestApi) {
      root.AdvantEdgeMetricsServiceRestApi = {};
    }
    root.AdvantEdgeMetricsServiceRestApi.HttpMetric = factory(root.AdvantEdgeMetricsServiceRestApi.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';

  /**
   * The HttpMetric model module.
   * @module model/HttpMetric
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>HttpMetric</code>.
   * Value of a single http metric
   * @alias module:model/HttpMetric
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>HttpMetric</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/HttpMetric} obj Optional instance to populate.
   * @return {module:model/HttpMetric} The populated <code>HttpMetric</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('time'))
        obj.time = ApiClient.convertToType(data['time'], 'String');
      if (data.hasOwnProperty('id'))
        obj.id = ApiClient.convertToType(data['id'], 'Number');
      if (data.hasOwnProperty('endpoint'))
        obj.endpoint = ApiClient.convertToType(data['endpoint'], 'String');
      if (data.hasOwnProperty('url'))
        obj.url = ApiClient.convertToType(data['url'], 'String');
      if (data.hasOwnProperty('method'))
        obj.method = ApiClient.convertToType(data['method'], 'String');
      if (data.hasOwnProperty('resp_code'))
        obj.respCode = ApiClient.convertToType(data['resp_code'], 'String');
      if (data.hasOwnProperty('resp_body'))
        obj.respBody = ApiClient.convertToType(data['resp_body'], 'String');
      if (data.hasOwnProperty('body'))
        obj.body = ApiClient.convertToType(data['body'], 'String');
      if (data.hasOwnProperty('proc_time'))
        obj.procTime = ApiClient.convertToType(data['proc_time'], 'String');
      if (data.hasOwnProperty('logger_name'))
        obj.loggerName = ApiClient.convertToType(data['logger_name'], 'String');
      if (data.hasOwnProperty('msg_type'))
        obj.msgType = ApiClient.convertToType(data['msg_type'], 'String');
      if (data.hasOwnProperty('direction'))
        obj.direction = ApiClient.convertToType(data['direction'], 'String');
    }
    return obj;
  }

  /**
   * Time of http metrics
   * @member {String} time
   */
  exports.prototype.time = undefined;

  /**
   * Http metrics identifier
   * @member {Number} id
   */
  exports.prototype.id = undefined;

  /**
   * Http metrics queried endpoint
   * @member {String} endpoint
   */
  exports.prototype.endpoint = undefined;

  /**
   * Http metrics queried endpoint with query parameters
   * @member {String} url
   */
  exports.prototype.url = undefined;

  /**
   * Http metrics method
   * @member {String} method
   */
  exports.prototype.method = undefined;

  /**
   * Http metrics response status code
   * @member {String} respCode
   */
  exports.prototype.respCode = undefined;

  /**
   * Http metrics response body
   * @member {String} respBody
   */
  exports.prototype.respBody = undefined;

  /**
   * Http metrics body
   * @member {String} body
   */
  exports.prototype.body = undefined;

  /**
   * Request processing time in ms
   * @member {String} procTime
   */
  exports.prototype.procTime = undefined;

  /**
   * Service processing the http metric
   * @member {String} loggerName
   */
  exports.prototype.loggerName = undefined;

  /**
   * Http metric type (request, response, notification)
   * @member {String} msgType
   */
  exports.prototype.msgType = undefined;

  /**
   * DEPRECATED -- Http type
   * @member {String} direction
   */
  exports.prototype.direction = undefined;

  return exports;

}));
