/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Metrics Service REST API
 * Metrics Service provides metrics about the active scenario <p>**Micro-service**<br>[meep-metrics-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-metrics-engine) <p>**Type & Usage**<br>Platform Service used by control/monitoring software and possibly by edge applications that require metrics <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/EventSubscription', 'model/EventSubscriptionList', 'model/EventSubscriptionParams', 'model/NetworkSubscription', 'model/NetworkSubscriptionList', 'model/NetworkSubscriptionParams'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../model/EventSubscription'), require('../model/EventSubscriptionList'), require('../model/EventSubscriptionParams'), require('../model/NetworkSubscription'), require('../model/NetworkSubscriptionList'), require('../model/NetworkSubscriptionParams'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeMetricsServiceRestApi) {
      root.AdvantEdgeMetricsServiceRestApi = {};
    }
    root.AdvantEdgeMetricsServiceRestApi.SubscriptionsApi = factory(root.AdvantEdgeMetricsServiceRestApi.ApiClient, root.AdvantEdgeMetricsServiceRestApi.EventSubscription, root.AdvantEdgeMetricsServiceRestApi.EventSubscriptionList, root.AdvantEdgeMetricsServiceRestApi.EventSubscriptionParams, root.AdvantEdgeMetricsServiceRestApi.NetworkSubscription, root.AdvantEdgeMetricsServiceRestApi.NetworkSubscriptionList, root.AdvantEdgeMetricsServiceRestApi.NetworkSubscriptionParams);
  }
}(this, function(ApiClient, EventSubscription, EventSubscriptionList, EventSubscriptionParams, NetworkSubscription, NetworkSubscriptionList, NetworkSubscriptionParams) {
  'use strict';

  /**
   * Subscriptions service.
   * @module api/SubscriptionsApi
   * @version 1.0.0
   */

  /**
   * Constructs a new SubscriptionsApi. 
   * @alias module:api/SubscriptionsApi
   * @class
   * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
   * default to {@link module:ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the createEventSubscription operation.
     * @callback module:api/SubscriptionsApi~createEventSubscriptionCallback
     * @param {String} error Error message, if any.
     * @param {module:model/EventSubscription} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create an Event subscription
     * @param {module:model/EventSubscriptionParams} params Event subscription parameters
     * @param {module:api/SubscriptionsApi~createEventSubscriptionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/EventSubscription}
     */
    this.createEventSubscription = function(params, callback) {
      var postBody = params;

      // verify the required parameter 'params' is set
      if (params === undefined || params === null) {
        throw new Error("Missing the required parameter 'params' when calling createEventSubscription");
      }


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = EventSubscription;

      return this.apiClient.callApi(
        '/metrics/subscriptions/event', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createNetworkSubscription operation.
     * @callback module:api/SubscriptionsApi~createNetworkSubscriptionCallback
     * @param {String} error Error message, if any.
     * @param {module:model/NetworkSubscription} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a Network subscription
     * @param {module:model/NetworkSubscriptionParams} params Network subscription parameters
     * @param {module:api/SubscriptionsApi~createNetworkSubscriptionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/NetworkSubscription}
     */
    this.createNetworkSubscription = function(params, callback) {
      var postBody = params;

      // verify the required parameter 'params' is set
      if (params === undefined || params === null) {
        throw new Error("Missing the required parameter 'params' when calling createNetworkSubscription");
      }


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = NetworkSubscription;

      return this.apiClient.callApi(
        '/metrics/subscriptions/network', 'POST',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteEventSubscriptionById operation.
     * @callback module:api/SubscriptionsApi~deleteEventSubscriptionByIdCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns an Event subscription
     * @param {String} subscriptionId Subscription ID - returned when the subscription was created
     * @param {module:api/SubscriptionsApi~deleteEventSubscriptionByIdCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteEventSubscriptionById = function(subscriptionId, callback) {
      var postBody = null;

      // verify the required parameter 'subscriptionId' is set
      if (subscriptionId === undefined || subscriptionId === null) {
        throw new Error("Missing the required parameter 'subscriptionId' when calling deleteEventSubscriptionById");
      }


      var pathParams = {
        'subscriptionId': subscriptionId
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;

      return this.apiClient.callApi(
        '/metrics/subscriptions/event/{subscriptionId}', 'DELETE',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteNetworkSubscriptionById operation.
     * @callback module:api/SubscriptionsApi~deleteNetworkSubscriptionByIdCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns a Network subscription
     * @param {String} subscriptionId Subscription ID - returned when the subscription was created
     * @param {module:api/SubscriptionsApi~deleteNetworkSubscriptionByIdCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteNetworkSubscriptionById = function(subscriptionId, callback) {
      var postBody = null;

      // verify the required parameter 'subscriptionId' is set
      if (subscriptionId === undefined || subscriptionId === null) {
        throw new Error("Missing the required parameter 'subscriptionId' when calling deleteNetworkSubscriptionById");
      }


      var pathParams = {
        'subscriptionId': subscriptionId
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;

      return this.apiClient.callApi(
        '/metrics/subscriptions/network/{subscriptionId}', 'DELETE',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getEventSubscription operation.
     * @callback module:api/SubscriptionsApi~getEventSubscriptionCallback
     * @param {String} error Error message, if any.
     * @param {module:model/EventSubscriptionList} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns all Event subscriptions
     * @param {module:api/SubscriptionsApi~getEventSubscriptionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/EventSubscriptionList}
     */
    this.getEventSubscription = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = EventSubscriptionList;

      return this.apiClient.callApi(
        '/metrics/subscriptions/event', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getEventSubscriptionById operation.
     * @callback module:api/SubscriptionsApi~getEventSubscriptionByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/EventSubscription} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns an Event subscription
     * @param {String} subscriptionId Subscription ID - returned when the subscription was created
     * @param {module:api/SubscriptionsApi~getEventSubscriptionByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/EventSubscription}
     */
    this.getEventSubscriptionById = function(subscriptionId, callback) {
      var postBody = null;

      // verify the required parameter 'subscriptionId' is set
      if (subscriptionId === undefined || subscriptionId === null) {
        throw new Error("Missing the required parameter 'subscriptionId' when calling getEventSubscriptionById");
      }


      var pathParams = {
        'subscriptionId': subscriptionId
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = EventSubscription;

      return this.apiClient.callApi(
        '/metrics/subscriptions/event/{subscriptionId}', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getNetworkSubscription operation.
     * @callback module:api/SubscriptionsApi~getNetworkSubscriptionCallback
     * @param {String} error Error message, if any.
     * @param {module:model/NetworkSubscriptionList} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns all Network subscriptions
     * @param {module:api/SubscriptionsApi~getNetworkSubscriptionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/NetworkSubscriptionList}
     */
    this.getNetworkSubscription = function(callback) {
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = NetworkSubscriptionList;

      return this.apiClient.callApi(
        '/metrics/subscriptions/network', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getNetworkSubscriptionById operation.
     * @callback module:api/SubscriptionsApi~getNetworkSubscriptionByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/NetworkSubscription} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns a Network subscription
     * @param {String} subscriptionId Subscription ID - returned when the subscription was created
     * @param {module:api/SubscriptionsApi~getNetworkSubscriptionByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/NetworkSubscription}
     */
    this.getNetworkSubscriptionById = function(subscriptionId, callback) {
      var postBody = null;

      // verify the required parameter 'subscriptionId' is set
      if (subscriptionId === undefined || subscriptionId === null) {
        throw new Error("Missing the required parameter 'subscriptionId' when calling getNetworkSubscriptionById");
      }


      var pathParams = {
        'subscriptionId': subscriptionId
      };
      var queryParams = {
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = NetworkSubscription;

      return this.apiClient.callApi(
        '/metrics/subscriptions/network/{subscriptionId}', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
