# Go API client for swagger

ETSI GS MEC 030 V2X Information Services API described using OpenAPI.

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 3.1.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen
For more information, please visit [https://forge.etsi.org/rep/mec/gs030-vis-api](https://forge.etsi.org/rep/mec/gs030-vis-api)

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/vis/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*QoSApi* | [**PredictedQosPOST**](docs/QoSApi.md#predictedqospost) | **Post** /provide_predicted_qos | Request the predicted QoS correspondent to potential routes of a vehicular UE.
*QueriesApi* | [**ProvInfoGET**](docs/QueriesApi.md#provinfoget) | **Get** /queries/pc5_provisioning_info | Query provisioning information for V2X communication over PC5.
*QueriesApi* | [**ProvInfoUuMbmsGET**](docs/QueriesApi.md#provinfouumbmsget) | **Get** /queries/uu_mbms_provisioning_info | retrieve information required for V2X communication over Uu MBMS.
*QueriesApi* | [**ProvInfoUuUnicastGET**](docs/QueriesApi.md#provinfouuunicastget) | **Get** /queries/uu_unicast_provisioning_info | Used to query provisioning information for V2X communication over Uu unicast.
*SubscriptionApi* | [**IndividualSubscriptionDELETE**](docs/SubscriptionApi.md#individualsubscriptiondelete) | **Delete** /subscriptions/{subscriptionId} | Used to cancel the existing subscription.
*SubscriptionApi* | [**IndividualSubscriptionGET**](docs/SubscriptionApi.md#individualsubscriptionget) | **Get** /subscriptions/{subscriptionId} | Retrieve information about this subscription.
*SubscriptionApi* | [**IndividualSubscriptionPUT**](docs/SubscriptionApi.md#individualsubscriptionput) | **Put** /subscriptions/{subscriptionId} | Used to update the existing subscription.
*SubscriptionApi* | [**SubGET**](docs/SubscriptionApi.md#subget) | **Get** /subscriptions | Request information about the subscriptions for this requestor.
*SubscriptionApi* | [**SubPOST**](docs/SubscriptionApi.md#subpost) | **Post** /subscriptions |  create a new subscription to VIS notifications.
*V2XMsgApi* | [**V2xMessagePOST**](docs/V2XMsgApi.md#v2xmessagepost) | **Post** /publish_v2x_message | Used to publish a V2X message.
*V2XMsgApi* | [**V2xMsgDistributionServerPost**](docs/V2XMsgApi.md#v2xmsgdistributionserverpost) | **Post** /provide_v2x_msg_distribution_server_info | Request the information about available V2X Message Distribution Servers that can be supported by the service consumer.

## Documentation For Models

 - [AnyOfPredQosSubscription](docs/AnyOfPredQosSubscription.md)
 - [AnyOfProvChgPc5Subscription](docs/AnyOfProvChgPc5Subscription.md)
 - [AnyOfProvChgUuMbmsSubscription](docs/AnyOfProvChgUuMbmsSubscription.md)
 - [AnyOfProvChgUuUniSubscription](docs/AnyOfProvChgUuUniSubscription.md)
 - [AnyOfV2xMsgSubscription](docs/AnyOfV2xMsgSubscription.md)
 - [CellId](docs/CellId.md)
 - [Earfcn](docs/Earfcn.md)
 - [Ecgi](docs/Ecgi.md)
 - [FddInfo](docs/FddInfo.md)
 - [InfoConnection](docs/InfoConnection.md)
 - [InfoProtocol](docs/InfoProtocol.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [LinkType](docs/LinkType.md)
 - [Links](docs/Links.md)
 - [Links1](docs/Links1.md)
 - [Links2](docs/Links2.md)
 - [Links3](docs/Links3.md)
 - [LocationInfo](docs/LocationInfo.md)
 - [LocationInfoGeoArea](docs/LocationInfoGeoArea.md)
 - [MsgType](docs/MsgType.md)
 - [OneOfinlineResponse200](docs/OneOfinlineResponse200.md)
 - [OneOfsubscriptionsBody](docs/OneOfsubscriptionsBody.md)
 - [OneOfsubscriptionsSubscriptionIdBody](docs/OneOfsubscriptionsSubscriptionIdBody.md)
 - [Pc5NeighbourCellInfo](docs/Pc5NeighbourCellInfo.md)
 - [Pc5ProvisioningInfo](docs/Pc5ProvisioningInfo.md)
 - [Pc5ProvisioningInfoProInfoPc5](docs/Pc5ProvisioningInfoProInfoPc5.md)
 - [Plmn](docs/Plmn.md)
 - [PredQosSubscription](docs/PredQosSubscription.md)
 - [PredictedQos](docs/PredictedQos.md)
 - [PredictedQosRoutes](docs/PredictedQosRoutes.md)
 - [PredictedQosRoutesRouteInfo](docs/PredictedQosRoutesRouteInfo.md)
 - [PredictionArea](docs/PredictionArea.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [ProvChgPc5Notification](docs/ProvChgPc5Notification.md)
 - [ProvChgPc5Subscription](docs/ProvChgPc5Subscription.md)
 - [ProvChgPc5SubscriptionFilterCriteria](docs/ProvChgPc5SubscriptionFilterCriteria.md)
 - [ProvChgUuMbmsNotification](docs/ProvChgUuMbmsNotification.md)
 - [ProvChgUuMbmsSubscription](docs/ProvChgUuMbmsSubscription.md)
 - [ProvChgUuMbmsSubscriptionFilterCriteria](docs/ProvChgUuMbmsSubscriptionFilterCriteria.md)
 - [ProvChgUuUniNotification](docs/ProvChgUuUniNotification.md)
 - [ProvChgUuUniSubscription](docs/ProvChgUuUniSubscription.md)
 - [ProvChgUuUniSubscriptionFilterCriteria](docs/ProvChgUuUniSubscriptionFilterCriteria.md)
 - [Qos](docs/Qos.md)
 - [QosKpi](docs/QosKpi.md)
 - [QosPredFilterCriteria](docs/QosPredFilterCriteria.md)
 - [RouteInfo](docs/RouteInfo.md)
 - [Routes](docs/Routes.md)
 - [Stream](docs/Stream.md)
 - [SubscriptionLinkList](docs/SubscriptionLinkList.md)
 - [Subscriptions](docs/Subscriptions.md)
 - [SubscriptionsBody](docs/SubscriptionsBody.md)
 - [SubscriptionsSubscriptionIdBody](docs/SubscriptionsSubscriptionIdBody.md)
 - [SystemInformationBlockType21](docs/SystemInformationBlockType21.md)
 - [TddInfo](docs/TddInfo.md)
 - [TestNotification](docs/TestNotification.md)
 - [TestNotificationLinks](docs/TestNotificationLinks.md)
 - [TimeStamp](docs/TimeStamp.md)
 - [TransmissionBandwidth](docs/TransmissionBandwidth.md)
 - [TransmissionBandwidthTransmissionBandwidth](docs/TransmissionBandwidthTransmissionBandwidth.md)
 - [UuMbmsNeighbourCellInfo](docs/UuMbmsNeighbourCellInfo.md)
 - [UuMbmsProvisioningInfo](docs/UuMbmsProvisioningInfo.md)
 - [UuMbmsProvisioningInfoProInfoUuMbms](docs/UuMbmsProvisioningInfoProInfoUuMbms.md)
 - [UuUniNeighbourCellInfo](docs/UuUniNeighbourCellInfo.md)
 - [UuUnicastProvisioningInfo](docs/UuUnicastProvisioningInfo.md)
 - [UuUnicastProvisioningInfoProInfoUuUnicast](docs/UuUnicastProvisioningInfoProInfoUuUnicast.md)
 - [V2xApplicationServer](docs/V2xApplicationServer.md)
 - [V2xMsgDistributionServer](docs/V2xMsgDistributionServer.md)
 - [V2xMsgDistributionServerInfo](docs/V2xMsgDistributionServerInfo.md)
 - [V2xMsgFilterCriteria](docs/V2xMsgFilterCriteria.md)
 - [V2xMsgNotification](docs/V2xMsgNotification.md)
 - [V2xMsgNotificationLinks](docs/V2xMsgNotificationLinks.md)
 - [V2xMsgPropertiesValues](docs/V2xMsgPropertiesValues.md)
 - [V2xMsgPublication](docs/V2xMsgPublication.md)
 - [V2xMsgSubscription](docs/V2xMsgSubscription.md)
 - [V2xMsgSubscriptionFilterCriteria](docs/V2xMsgSubscriptionFilterCriteria.md)
 - [V2xServerUsd](docs/V2xServerUsd.md)
 - [V2xServerUsdSdpInfo](docs/V2xServerUsdSdpInfo.md)
 - [V2xServerUsdTmgi](docs/V2xServerUsdTmgi.md)
 - [WebsockNotifConfig](docs/WebsockNotifConfig.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

cti_support@etsi.org
