/*
 * MEC Service Management API
 *
 * The ETSI MEC ISG MEC011 MEC Service Management API described using OpenAPI
 *
 * API version: 3.1.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

// This type represents the general information of a MEC service.
type TransportInfo struct {
	// The identifier of this transport
	Id string `json:"id"`
	// The name of this transport
	Name string `json:"name"`
	// Human-readable description of this transport
	Description string         `json:"description,omitempty"`
	Type_       *TransportType `json:"type"`
	// The name of the protocol used. Shall be set to HTTP for a REST API.
	Protocol string `json:"protocol"`
	// The version of the protocol used
	Version string `json:"version"`
	// This type represents information about a transport endpoint
	Endpoint *OneOfTransportInfoEndpoint `json:"endpoint"`
	Security *SecurityInfo               `json:"security"`
	// Additional implementation specific details of the transport
	ImplSpecificInfo string `json:"implSpecificInfo,omitempty"`
}
