# Go API client for swagger

The MEC Sandbox API described using OpenAPI

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 0.0.3
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *http://127.0.0.1:8081/sandbox_api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthorizationApi* | [**Login**](docs/AuthorizationApi.md#login) | **Post** /login | Initiate OAuth login procedure and creates MEC Sandbox
*AuthorizationApi* | [**Logout**](docs/AuthorizationApi.md#logout) | **Post** /logout | Terminates User Session and User Sandbox
*SandboxAppInstancesApi* | [**SandboxAppInstancesGET**](docs/SandboxAppInstancesApi.md#sandboxappinstancesget) | **Get** /sandboxAppInstances | get the list of the available application instance identifier
*SandboxLogsSubscriptionsApi* | [**SandboxLogsSubscriptionsDELETE**](docs/SandboxLogsSubscriptionsApi.md#sandboxlogssubscriptionsdelete) | **Delete** /sandboxLogsSubscriptions/{subscription_reference} | Subscription to receive logs from the sandbox
*SandboxLogsSubscriptionsApi* | [**SandboxLogsSubscriptionsPOST**](docs/SandboxLogsSubscriptionsApi.md#sandboxlogssubscriptionspost) | **Post** /sandboxLogsSubscriptions | Subscription to receive logs from the sandbox
*SandboxMECServicesApi* | [**SandboxMecServicesGET**](docs/SandboxMECServicesApi.md#sandboxmecservicesget) | **Get** /sandboxMecServices | get the list of the available MEC services
*SandboxMECServicesApi* | [**SandboxMecServicesPOST**](docs/SandboxMECServicesApi.md#sandboxmecservicespost) | **Post** /sandboxMecServices/{mec_service_name} | select the MEC services to use
*SandboxNetworkScenariosApi* | [**SandboxNetworkScenariosGET**](docs/SandboxNetworkScenariosApi.md#sandboxnetworkscenariosget) | **Get** /sandboxNetworkScenarios | get the list of the available network scenarios
*SandboxNetworkScenariosApi* | [**SandboxNetworkScenarioPOST**](docs/SandboxNetworkScenariosApi.md#sandboxnetworkscenariospost) | **Post** /sandboxNetworkScenarios/{network_scenario_id} | Selects the Network Scenario to be used.
*SandboxUEControllerApi* | [**SandboxUeControllerGET**](docs/SandboxUEControllerApi.md#sandboxuecontrollerget) | **Get** /sandboxUeController | get the list of the available UEs (e.g. \&quot;Stationary UE\&quot;)
*SandboxUEControllerApi* | [**SandboxUeControllerPATCH**](docs/SandboxUEControllerApi.md#sandboxuecontrollerpatch) | **Patch** /sandboxUeController/{user_equipment_id} | set the new value of the UE

## Documentation For Models

 - [ProblemDetails](docs/ProblemDetails.md)
 - [Sandbox](docs/Sandbox.md)
 - [SandboxAppInstances](docs/SandboxAppInstances.md)
 - [SandboxLogsSubscriptions](docs/SandboxLogsSubscriptions.md)
 - [SandboxMecServices](docs/SandboxMecServices.md)
 - [SandboxNetworkScenario](docs/SandboxNetworkScenario.md)
 - [Ue](docs/Ue.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

cti_support@etsi.org
