# Go API client for client

This API is the main Platform Controller API for scenario configuration & sandbox management <p>**Micro-service**<br>[meep-pfm-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-platform-ctrl) <p>**Type & Usage**<br>Platform main interface used by controller software to configure scenarios and manage sandboxes in the AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/platform-ctrl/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*SandboxControlApi* | [**CreateSandbox**](docs/SandboxControlApi.md#createsandbox) | **Post** /sandboxes | Create a new sandbox
*SandboxControlApi* | [**CreateSandboxWithName**](docs/SandboxControlApi.md#createsandboxwithname) | **Post** /sandboxes/{name} | Create a new sandbox
*SandboxControlApi* | [**DeleteSandbox**](docs/SandboxControlApi.md#deletesandbox) | **Delete** /sandboxes/{name} | Delete a specific sandbox
*SandboxControlApi* | [**DeleteSandboxList**](docs/SandboxControlApi.md#deletesandboxlist) | **Delete** /sandboxes | Delete all active sandboxes
*SandboxControlApi* | [**GetSandbox**](docs/SandboxControlApi.md#getsandbox) | **Get** /sandboxes/{name} | Get a specific sandbox
*SandboxControlApi* | [**GetSandboxList**](docs/SandboxControlApi.md#getsandboxlist) | **Get** /sandboxes | Get all active sandboxes
*ScenarioConfigurationApi* | [**CreateScenario**](docs/ScenarioConfigurationApi.md#createscenario) | **Post** /scenarios/{name} | Add a scenario
*ScenarioConfigurationApi* | [**DeleteScenario**](docs/ScenarioConfigurationApi.md#deletescenario) | **Delete** /scenarios/{name} | Delete a scenario
*ScenarioConfigurationApi* | [**DeleteScenarioList**](docs/ScenarioConfigurationApi.md#deletescenariolist) | **Delete** /scenarios | Delete all scenarios
*ScenarioConfigurationApi* | [**GetScenario**](docs/ScenarioConfigurationApi.md#getscenario) | **Get** /scenarios/{name} | Get a specific scenario
*ScenarioConfigurationApi* | [**GetScenarioList**](docs/ScenarioConfigurationApi.md#getscenariolist) | **Get** /scenarios | Get all scenarios
*ScenarioConfigurationApi* | [**SetScenario**](docs/ScenarioConfigurationApi.md#setscenario) | **Put** /scenarios/{name} | Update a scenario


## Documentation For Models

 - [CellularDomainConfig](docs/CellularDomainConfig.md)
 - [CellularPoaConfig](docs/CellularPoaConfig.md)
 - [ConnectivityConfig](docs/ConnectivityConfig.md)
 - [CpuConfig](docs/CpuConfig.md)
 - [D2dConfig](docs/D2dConfig.md)
 - [Deployment](docs/Deployment.md)
 - [DnConfig](docs/DnConfig.md)
 - [Domain](docs/Domain.md)
 - [EgressService](docs/EgressService.md)
 - [ExternalConfig](docs/ExternalConfig.md)
 - [GeoData](docs/GeoData.md)
 - [GpuConfig](docs/GpuConfig.md)
 - [IngressService](docs/IngressService.md)
 - [LineString](docs/LineString.md)
 - [MemoryConfig](docs/MemoryConfig.md)
 - [NetworkCharacteristics](docs/NetworkCharacteristics.md)
 - [NetworkLocation](docs/NetworkLocation.md)
 - [PhysicalLocation](docs/PhysicalLocation.md)
 - [Poa4GConfig](docs/Poa4GConfig.md)
 - [Poa5GConfig](docs/Poa5GConfig.md)
 - [PoaWifiConfig](docs/PoaWifiConfig.md)
 - [Point](docs/Point.md)
 - [Process](docs/Process.md)
 - [Sandbox](docs/Sandbox.md)
 - [SandboxConfig](docs/SandboxConfig.md)
 - [SandboxList](docs/SandboxList.md)
 - [Scenario](docs/Scenario.md)
 - [ScenarioConfig](docs/ScenarioConfig.md)
 - [ScenarioList](docs/ScenarioList.md)
 - [ServiceConfig](docs/ServiceConfig.md)
 - [ServicePort](docs/ServicePort.md)
 - [Zone](docs/Zone.md)


## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com

