/*
 * Copyright (c) 2022  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Multi-access Traffic Steering API
 *
 * Multi-access Traffic Steering Sercice is AdvantEDGE's implementation of [ETSI MEC ISG MEC015 Traffic Management APIs](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/015/02.02.01_60/gs_MEC015v020201p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-tm](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-tm/server/mts) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about MTS Info and Session(s) in the network <p>**Note**<br>AdvantEDGE supports all Multi-access Traffic Steering API endpoints.
 *
 * API version: 2.2.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

type MtsSessionInfo struct {
	// MTS session instance identifier
	SessionId string `json:"sessionId,omitempty"`
	// Application instance identifier
	AppInsId string `json:"appInsId"`
	// Name of the application
	AppName string `json:"appName,omitempty"`
	// Traffic flow filtering criteria, applicable only if when requestType is set as FLOW_SPECIFIC_MTS_SESSION. Any filtering criteria shall define a single session only. In case multiple sessions match flowFilter the request shall be rejected. If the flowFilter field is included, at least one of its subfields shall be included. Any flowFilter subfield that is not included shall be ignored in traffic flow filtering
	FlowFilter []MtsSessionInfoFlowFilter `json:"flowFilter"`
	// Numeric value (0 - 255) corresponding to a specific MTS mode of the MTS session: 0 = low cost, i.e. using the unmetered access network connection whenever it is available 1 = low latency, i.e. using the access network connection with lower latency 2 = high throughput, i.e. using the access network connection with higher throughput, or multiple access network connection simultaneously 3 = redundancy, i.e. sending duplicated (redundancy) packets over multiple access network connections for high-reliability and low-latency applications 4 = QoS, i.e. performing MTS based on the QoS requirement (qosD)
	MtsMode int32               `json:"mtsMode"`
	QosD    *MtsSessionInfoQosD `json:"qosD"`
	// Numeric value (0 - 255) corresponding to specific type of consumer as following: 0 = APPLICATION_SPECIFIC_MTS_SESSION 1 = FLOW_SPECIFIC_MTS_SESSION
	RequestType int32                    `json:"requestType"`
	TimeStamp   *MtsSessionInfoTimeStamp `json:"timeStamp,omitempty"`
	// The direction of the requested MTS session: 00 = Downlink (towards the UE) 01 = Uplink (towards the application/session) 10 = Symmetrical (see note)
	TrafficDirection string `json:"trafficDirection"`
}
