/*
 * AdvantEDGE Location API
 *
 * Location Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC013 Location API](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/013/03.01.01_60/gs_mec013v030101p.pdf) <p>The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-loc-serv](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-loc-serv) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about Users (UE) and Zone locations <p>**Note**<br>AdvantEDGE supports all of Location API endpoints (see below).
 *
 * API version: 3.1.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

type UserLocationEventNotification struct {
	// The identity of the access point. For the events of \"ENTERING_AREA_EVENT\", it indicates the access point that the user is currently within.  For the event of \"LEAVING_AREA_EVENT\", it indicates the access point that the user used to be within. See note 2.
	AccessPointId string `json:"accessPointId,omitempty"`
	// Address of user (e.g. ‘sip’ URI, ‘tel’ URI, ‘acr’ URI).
	Address      string        `json:"address,omitempty"`
	CivicInfo    *CivicAddress `json:"civicInfo,omitempty"`
	LocationInfo *LocationInfo `json:"locationInfo,omitempty"`
	// Shall be set to \"UserLocationEventNotification\".
	NotificationType     string                `json:"notificationType"`
	RelativeLocationInfo *RelativeLocationInfo `json:"relativeLocationInfo,omitempty"`
	TimeStamp            *TimeStamp            `json:"timeStamp,omitempty"`
	UserLocationEvent    *LocationEventType    `json:"userLocationEvent"`
	// The identity of the zone.  For the events of \"ENTERING_AREA_EVENT\", it is the zone that the user is currently within.  For the event of \"LEAVING_AREA_EVENT\", it is the zone that the user used to be within. See note 2.
	ZoneId string                     `json:"zoneId,omitempty"`
	Links  *UserAreaNotificationLinks `json:"_links"`
}
