# Go API client for swagger

The ETSI MEC ISG MEC040 Federation enablement API described using OpenAPI

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 3.2.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen
For more information, please visit [https://forge.etsi.org/rep/mec/gs040-fed-enablement-api](https://forge.etsi.org/rep/mec/gs040-fed-enablement-api)

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/fed_enablement/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*FedServiceInfoApi* | [**ServiceGET**](docs/FedServiceInfoApi.md#serviceget) | **Get** /fed_resources/systems/{systemId}/services/{serviceId} | Retrieves the information of a specific MEC service hosted by the MEC system associated with the systemId and serviceId
*FedServiceInfoApi* | [**ServicesGET**](docs/FedServiceInfoApi.md#servicesget) | **Get** /fed_resources/systems/{systemId}/services | Retrieves the information of all MEC services hosted by the MEC system
*SubscriptionApi* | [**SubscriptionDELETE**](docs/SubscriptionApi.md#subscriptiondelete) | **Delete** /subscriptions/{subscriptionId} | Cancel an existing subscription
*SubscriptionApi* | [**SubscriptionGET**](docs/SubscriptionApi.md#subscriptionget) | **Get** /subscriptions/{subscriptionId} | Retrieve information on current specific subscription
*SubscriptionApi* | [**SubscriptionPOST**](docs/SubscriptionApi.md#subscriptionpost) | **Post** /subscriptions | Create a new subscription
*SubscriptionApi* | [**SubscriptionPUT**](docs/SubscriptionApi.md#subscriptionput) | **Put** /subscriptions/{subscriptionId} | Modify an existing subscription
*SubscriptionApi* | [**SubscriptionsGET**](docs/SubscriptionApi.md#subscriptionsget) | **Get** /subscriptions | Retrieve information on subscriptions for notifications
*SystemInfoApi* | [**SysteminfoByIdDELETE**](docs/SystemInfoApi.md#systeminfobyiddelete) | **Delete** /fed_resources/systems/{systemId} | Delete the systems resource for a given MEC system.
*SystemInfoApi* | [**SysteminfoByIdGET**](docs/SystemInfoApi.md#systeminfobyidget) | **Get** /fed_resources/systems/{systemId} | Retrieve the systems resource of the federation member with systemId as its system identifier.
*SystemInfoApi* | [**SysteminfoByIdPATCH**](docs/SystemInfoApi.md#systeminfobyidpatch) | **Patch** /fed_resources/systems/{systemId} | Update the systems resource for a given MEC system.
*SystemInfoApi* | [**SysteminfoGET**](docs/SystemInfoApi.md#systeminfoget) | **Get** /fed_resources/systems | Retrieve a list of systems resources (see clause 6 for data model) of federation members.
*SystemInfoApi* | [**SysteminfoPOST**](docs/SystemInfoApi.md#systeminfopost) | **Post** /fed_resources/systems | Create new systems resource for a given MEC system.

## Documentation For Models

 - [CategoryRef](docs/CategoryRef.md)
 - [FedResourcesSystemsBody](docs/FedResourcesSystemsBody.md)
 - [FedServiceInfo](docs/FedServiceInfo.md)
 - [LinkType](docs/LinkType.md)
 - [Links](docs/Links.md)
 - [Links1](docs/Links1.md)
 - [MecHostInformation](docs/MecHostInformation.md)
 - [OAuth2Info](docs/OAuth2Info.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [SecurityInfo](docs/SecurityInfo.md)
 - [SerializerType](docs/SerializerType.md)
 - [ServiceInfo](docs/ServiceInfo.md)
 - [SubscriptionLinkList](docs/SubscriptionLinkList.md)
 - [SubscriptionLinkListSubscription](docs/SubscriptionLinkListSubscription.md)
 - [SystemInfo](docs/SystemInfo.md)
 - [SystemInfoUpdate](docs/SystemInfoUpdate.md)
 - [SystemUpdateNotification](docs/SystemUpdateNotification.md)
 - [SystemUpdateNotificationSubscription](docs/SystemUpdateNotificationSubscription.md)
 - [SystemsSystemIdBody](docs/SystemsSystemIdBody.md)
 - [TimeStamp](docs/TimeStamp.md)
 - [TransportDescriptor](docs/TransportDescriptor.md)
 - [TransportTypes](docs/TransportTypes.md)
 - [TransportsSupported](docs/TransportsSupported.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author


