/*
 * ETSI GS MEC 016 Device application interface
 *
 * The ETSI MEC ISG Device application interface API described using OpenAPI.
 *
 * API version: 2.2.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

type ApplicationListAppInfo struct {
	AppCharcs *ApplicationListAppInfoAppCharcs `json:"appCharcs,omitempty"`
	// Identifier of this MEC application descriptor. It is equivalent to the appDId defined in clause 6.2.1.2 of ETSI GS MEC 0102 [1]. This attribute shall be globally unique.
	AppDId string `json:"appDId"`
	// Identifies the version of the application descriptor. It is equivalent to the appDVersion defined in clause 6.2.1.2 of ETSI GS MEC 0102 [1].
	AppDVersion string `json:"appDVersion"`
	// Human readable description of the MEC application (see note 2).
	AppDescription string `json:"appDescription"`
	// Identifies the locations of the MEC application.
	AppLocation []LocationConstraints `json:"appLocation,omitempty"`
	// Name of the MEC application. The length of the value shall not exceed 32 characters.
	AppName string `json:"appName"`
	// Provider of the MEC application. The length of the value shall not exceed 32 characters.
	AppProvider string `json:"appProvider"`
	// Software version of the MEC application. The length of the value shall not exceed 32 characters.
	AppSoftVersion string `json:"appSoftVersion"`
}
