/*
 * ETSI GS MEC 016 Device application interface
 *
 * The ETSI MEC ISG Device application interface API described using OpenAPI.
 *
 * API version: 2.2.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

type AppContextAppInfo struct {
	// Identifier of this MEC application descriptor. This attribute shall be globally unique. It is equivalent to the appDId defined in clause 6.2.1.2 of ETSI GS MEC 0102 [1]. It shall be present if the application is one in the ApplicationList.
	AppDId string `json:"appDId,omitempty"`
	// Identifies the version of the application descriptor. It is equivalent to the appDVersion defined in clause 6.2.1.2 of ETSI GS MEC 0102 [1].
	AppDVersion string `json:"appDVersion"`
	// Human readable description of the MEC application. The length of the value shall not exceed 128 characters.
	AppDescription string `json:"appDescription,omitempty"`
	// Name of the MEC application. The length of the value shall not exceed 32 characters.
	AppName string `json:"appName"`
	// Provider of the MEC application. The length of the value shall not exceed 32 characters.
	AppProvider string `json:"appProvider"`
	// Software version of the MEC application. The length of the value shall not exceed 32 characters.
	AppSoftVersion string `json:"appSoftVersion,omitempty"`
	// URI of the application package. Included in the request if the application is not one in the ApplicationList. appPackageSource enables on-boarding of the application package into the MEC system. The application package shall comply with the definitions in clause 6.2.1.2 of ETSI GS MEC 0102 [1].
	AppPackageSource string `json:"appPackageSource,omitempty"`
	// List of user application instance information.
	UserAppInstanceInfo []AppContextAppInfoUserAppInstanceInfo `json:"userAppInstanceInfo"`
}
