# Go API client for swagger

The ETSI MEC ISG Device application interface API described using OpenAPI.

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 2.2.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen
For more information, please visit [https://forge.etsi.org/rep/mec/gs016-dev-app-api](https://forge.etsi.org/rep/mec/gs016-dev-app-api)

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/dev_app/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AppTermApi* | [**Mec011AppTerminationPOST**](docs/AppTermApi.md#mec011appterminationpost) | **Post** /subscriptions/{subscriptionId} | MEC011 Application Termination notification for self termination
*DevAppApi* | [**AppLocationAvailabilityPOST**](docs/DevAppApi.md#applocationavailabilitypost) | **Post** /obtain_app_loc_availability | Obtain the location constraints for a new application context.
*DevAppApi* | [**DevAppContextDELETE**](docs/DevAppApi.md#devappcontextdelete) | **Delete** /app_contexts/{contextId} | Deletion of an existing application context.
*DevAppApi* | [**DevAppContextPUT**](docs/DevAppApi.md#devappcontextput) | **Put** /app_contexts/{contextId} | Updating the callbackReference and/or appLocation of an existing application context.
*DevAppApi* | [**DevAppContextsPOST**](docs/DevAppApi.md#devappcontextspost) | **Post** /app_contexts | Creation of a new application context.
*DevAppApi* | [**MeAppListGET**](docs/DevAppApi.md#meapplistget) | **Get** /app_list | Get available application information.
*UnsupportedApi* | [**IndividualSubscriptionDELETE**](docs/UnsupportedApi.md#individualsubscriptiondelete) | **Delete** /subscriptions/{subscriptionId} | Used to cancel the existing subscription.

## Documentation For Models

 - [AddressChangeNotification](docs/AddressChangeNotification.md)
 - [AppContext](docs/AppContext.md)
 - [AppContextAppInfo](docs/AppContextAppInfo.md)
 - [AppContextAppInfoUserAppInstanceInfo](docs/AppContextAppInfoUserAppInstanceInfo.md)
 - [AppTerminationNotification](docs/AppTerminationNotification.md)
 - [AppTerminationNotificationLinks](docs/AppTerminationNotificationLinks.md)
 - [ApplicationContextDeleteNotification](docs/ApplicationContextDeleteNotification.md)
 - [ApplicationContextUpdateNotification](docs/ApplicationContextUpdateNotification.md)
 - [ApplicationContextUpdateNotificationUserAppInstanceInfo](docs/ApplicationContextUpdateNotificationUserAppInstanceInfo.md)
 - [ApplicationList](docs/ApplicationList.md)
 - [ApplicationListAppInfo](docs/ApplicationListAppInfo.md)
 - [ApplicationListAppInfoAppCharcs](docs/ApplicationListAppInfoAppCharcs.md)
 - [ApplicationListAppList](docs/ApplicationListAppList.md)
 - [ApplicationListVendorSpecificExt](docs/ApplicationListVendorSpecificExt.md)
 - [ApplicationLocationAvailability](docs/ApplicationLocationAvailability.md)
 - [ApplicationLocationAvailabilityAppInfo](docs/ApplicationLocationAvailabilityAppInfo.md)
 - [ApplicationLocationAvailabilityAppInfoAvailableLocations](docs/ApplicationLocationAvailabilityAppInfoAvailableLocations.md)
 - [ApplicationLocationAvailabilityNotification](docs/ApplicationLocationAvailabilityNotification.md)
 - [InlineNotification](docs/InlineNotification.md)
 - [LinkType](docs/LinkType.md)
 - [Links](docs/Links.md)
 - [LocationConstraints](docs/LocationConstraints.md)
 - [LocationConstraintsCivicAddressElement](docs/LocationConstraintsCivicAddressElement.md)
 - [OneOfInlineNotification](docs/OneOfInlineNotification.md)
 - [OperationActionType](docs/OperationActionType.md)
 - [Polygon](docs/Polygon.md)
 - [ProblemDetails](docs/ProblemDetails.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author


