# Go API client for swagger

The ETSI MEC ISG MEC011 MEC Service Management realized by CAPIF APIs described using OpenAPI

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 3.2.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/service-apis/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AppServicesApi* | [**AppServicesGET**](docs/AppServicesApi.md#appservicesget) | **Get** /{apfId}/service-apis | get services
*AppServicesApi* | [**AppServicesPOST**](docs/AppServicesApi.md#appservicespost) | **Post** /{apfId}/service-apis | Publish a new API
*AppServicesApi* | [**AppServicesServiceIdDELETE**](docs/AppServicesApi.md#appservicesserviceiddelete) | **Delete** /{apfId}/service-apis/{serviceApiId} | 
*AppServicesApi* | [**AppServicesServiceIdGET**](docs/AppServicesApi.md#appservicesserviceidget) | **Get** /{apfId}/service-apis/{serviceApiId} | 
*AppServicesApi* | [**AppServicesServiceIdPATCH**](docs/AppServicesApi.md#appservicesserviceidpatch) | **Patch** /{apfId}/service-apis/{serviceApiId} | 
*AppServicesApi* | [**AppServicesServiceIdPUT**](docs/AppServicesApi.md#appservicesserviceidput) | **Put** /{apfId}/service-apis/{serviceApiId} | 
*AppSubscriptionsApi* | [**ApplicationsSubscriptionDELETE**](docs/AppSubscriptionsApi.md#applicationssubscriptiondelete) | **Delete** /{subscriberId}/subscriptions/{subscriptionId}  | Delete an existing CAPIF Event Subscription
*AppSubscriptionsApi* | [**ApplicationsSubscriptionPatch**](docs/AppSubscriptionsApi.md#applicationssubscriptionpatch) | **Patch** /{subscriberId}/subscriptions/{subscriptionId}  | Modify an existing CAPIF Event Subscription
*AppSubscriptionsApi* | [**ApplicationsSubscriptionsPOST**](docs/AppSubscriptionsApi.md#applicationssubscriptionspost) | **Post** /{subscriberId}/subscriptions | Create a new CAPIF Events Subscription
*AppSubscriptionsApi* | [**ApplicationsSubscriptionsPUT**](docs/AppSubscriptionsApi.md#applicationssubscriptionsput) | **Put** /{subscriberId}/subscriptions/{subscriptionId}  | The PUT method is used to update an existing subscription resource.
*ServicesApi* | [**ServicesGET**](docs/ServicesApi.md#servicesget) | **Get** /allServiceAPIs | 

## Documentation For Models

 - [CapifEvent](docs/CapifEvent.md)
 - [CategoryRef](docs/CategoryRef.md)
 - [DiscoveredApis](docs/DiscoveredApis.md)
 - [EventNotification](docs/EventNotification.md)
 - [EventSubscription](docs/EventSubscription.md)
 - [EventSubscriptionPatch](docs/EventSubscriptionPatch.md)
 - [LocalityType](docs/LocalityType.md)
 - [MecServiceInfoCapifExt](docs/MecServiceInfoCapifExt.md)
 - [MecServiceInfoCapifExtPatch](docs/MecServiceInfoCapifExtPatch.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [SerializerType](docs/SerializerType.md)
 - [ServiceApiDescription](docs/ServiceApiDescription.md)
 - [ServiceApiDescriptionPatch](docs/ServiceApiDescriptionPatch.md)
 - [ServiceState](docs/ServiceState.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

cti_support@etsi.org
