/*
 * Copyright (c) 2024  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE MEC Application Support API
 *
 * MEC Application Support Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC011 Application Enablement API](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/011/03.01.01_60/gs_MEC011v030101p.pdf) <p>[Copyright (c) ETSI 2024](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-app-enablement](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-app-enablement/server/app-support) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about applications in the network <p>**Note**<br>AdvantEDGE supports a selected subset of Application Support API endpoints (see below).
 *
 * API version: 3.1.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

type AppProfile struct {
	// The identifier of the EAS
	EasId string `json:"easId"`
	// The version of the feature.
	EndPt *OneOfAppProfileEndPt `json:"endPt"`
	// Identities of the Application Clients that can be served by the EAS
	AcIds []string `json:"acIds"`
	// Identifier of the ASP that provides the EAS.
	ProvId string `json:"provId,omitempty"`
	// The category or type of EAS.
	Type_ string `json:"type,omitempty"`
	// The availability schedule of the EAS.
	Scheds []string `json:"scheds"`
	// The list of geographical and topological areas that the EAS serves. ACs in the UE that are outside the area will not be served.
	SvcArea string `json:"svcArea,omitempty"`
	// Service characteristics provided by the EAS.
	SvcKpi string `json:"svcKpi,omitempty"`
	// level of service permissions supported by the EAS.
	PermLvl []string `json:"permLvl"`
	// Service features supported by the EAS.
	EasFeats []string `json:"easFeats"`
	// The ACR scenarios supported by the EAS for service continuity.
	SvcContSupp []string `json:"svcContSupp"`
	// List of DNAI(s) and the N6 traffic information associated with the EAS.
	AppLocs []string `json:"appLocs"`
	// The period indicating to the EES, how often the EES needs to check the EAS's availability after a successful registration.
	AvlRep int32 `json:"avlRep,omitempty"`
	// EAS status information.
	Status string `json:"status,omitempty"`
}
