# Go API client for client

MEC Application Support Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC011 Application Enablement API](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/011/03.01.01_60/gs_MEC011v030101p.pdf) <p>[Copyright (c) ETSI 2024](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-app-enablement](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-app-enablement/server/app-support) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about applications in the network <p>**Note**<br>AdvantEDGE supports a selected subset of Application Support API endpoints (see below).

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 3.1.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/mec_app_support/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MecAppSupportApi* | [**ApplicationsConfirmReadyPOST**](docs/MecAppSupportApi.md#applicationsconfirmreadypost) | **Post** /applications/{appInstanceId}/confirm_ready | 
*MecAppSupportApi* | [**ApplicationsConfirmTerminationPOST**](docs/MecAppSupportApi.md#applicationsconfirmterminationpost) | **Post** /applications/{appInstanceId}/confirm_termination | 
*MecAppSupportApi* | [**ApplicationsRegistrationDELETE**](docs/MecAppSupportApi.md#applicationsregistrationdelete) | **Delete** /registrations/{appInstanceId} |
*MecAppSupportApi* | [**ApplicationsRegistrationGET**](docs/MecAppSupportApi.md#applicationsregistrationget) | **Get** /registrations/{appInstanceId} |
*MecAppSupportApi* | [**ApplicationsRegistrationPUT**](docs/MecAppSupportApi.md#applicationsregistrationput) | **Put** /registrations/{appInstanceId} |
*MecAppSupportApi* | [**ApplicationsRegistrationsPOST**](docs/MecAppSupportApi.md#applicationsregistrationspost) | **Post** /registrations |
*MecAppSupportApi* | [**ApplicationsSubscriptionDELETE**](docs/MecAppSupportApi.md#applicationssubscriptiondelete) | **Delete** /applications/{appInstanceId}/subscriptions/{subscriptionId} | 
*MecAppSupportApi* | [**ApplicationsSubscriptionGET**](docs/MecAppSupportApi.md#applicationssubscriptionget) | **Get** /applications/{appInstanceId}/subscriptions/{subscriptionId} | 
*MecAppSupportApi* | [**ApplicationsSubscriptionsGET**](docs/MecAppSupportApi.md#applicationssubscriptionsget) | **Get** /applications/{appInstanceId}/subscriptions | 
*MecAppSupportApi* | [**ApplicationsSubscriptionsPOST**](docs/MecAppSupportApi.md#applicationssubscriptionspost) | **Post** /applications/{appInstanceId}/subscriptions | 
*MecAppSupportApi* | [**TimingCapsGET**](docs/MecAppSupportApi.md#timingcapsget) | **Get** /timing/timing_caps | 
*MecAppSupportApi* | [**TimingCurrentTimeGET**](docs/MecAppSupportApi.md#timingcurrenttimeget) | **Get** /timing/current_time | 
*UnsupportedApi* | [**ApplicationsDnsRuleGET**](docs/UnsupportedApi.md#applicationsdnsruleget) | **Get** /applications/{appInstanceId}/dns_rules/{dnsRuleId} | 
*UnsupportedApi* | [**ApplicationsDnsRulePUT**](docs/UnsupportedApi.md#applicationsdnsruleput) | **Put** /applications/{appInstanceId}/dns_rules/{dnsRuleId} | 
*UnsupportedApi* | [**ApplicationsDnsRulesGET**](docs/UnsupportedApi.md#applicationsdnsrulesget) | **Get** /applications/{appInstanceId}/dns_rules | 
*UnsupportedApi* | [**ApplicationsTrafficRuleGET**](docs/UnsupportedApi.md#applicationstrafficruleget) | **Get** /applications/{appInstanceId}/traffic_rules/{trafficRuleId} | 
*UnsupportedApi* | [**ApplicationsTrafficRulePUT**](docs/UnsupportedApi.md#applicationstrafficruleput) | **Put** /applications/{appInstanceId}/traffic_rules/{trafficRuleId} | 
*UnsupportedApi* | [**ApplicationsTrafficRulesGET**](docs/UnsupportedApi.md#applicationstrafficrulesget) | **Get** /applications/{appInstanceId}/traffic_rules | 


## Documentation For Models


 - [AppInfo](docs/AppInfo.md)
 - [AppProfile](docs/AppProfile.md)
 - [AppReadyConfirmation](docs/AppReadyConfirmation.md)
 - [AppTerminationConfirmation](docs/AppTerminationConfirmation.md)
 - [AppTerminationNotification](docs/AppTerminationNotification.md)
 - [AppTerminationNotificationLinks](docs/AppTerminationNotificationLinks.md)
 - [AppTerminationNotificationSubscription](docs/AppTerminationNotificationSubscription.md)
 - [CategoryRef](docs/CategoryRef.md)
 - [CurrentTime](docs/CurrentTime.md)
 - [DestinationInterface](docs/DestinationInterface.md)
 - [DestinationInterfaceInterfaceType](docs/DestinationInterfaceInterfaceType.md)
 - [DnsRule](docs/DnsRule.md)
 - [DnsRuleIpAddressType](docs/DnsRuleIpAddressType.md)
 - [DnsRuleState](docs/DnsRuleState.md)
 - [EndPointInfoAddress](docs/EndPointInfoAddress.md)
 - [EndPointInfoAddresses](docs/EndPointInfoAddresses.md)
 - [EndPointInfoAlternative](docs/EndPointInfoAlternative.md)
 - [EndPointInfoFqdn](docs/EndPointInfoFqdn.md)
 - [EndPointInfoUris](docs/EndPointInfoUris.md)
 - [FeatureDependency](docs/FeatureDependency.md)
 - [LinkType](docs/LinkType.md)
 - [LinkTypeConfirmTermination](docs/LinkTypeConfirmTermination.md)
 - [MecAppSuptApiSubscriptionLinkList](docs/MecAppSuptApiSubscriptionLinkList.md)
 - [MecAppSuptApiSubscriptionLinkListLinks](docs/MecAppSuptApiSubscriptionLinkListLinks.md)
 - [MecAppSuptApiSubscriptionLinkListSubscription](docs/MecAppSuptApiSubscriptionLinkListSubscription.md)
 - [OneOfAppInfoEndpoint](docs/OneOfAppInfoEndpoint.md)
 - [OneOfAppProfileEndPt](docs/OneOfAppProfileEndPt.md)
 - [OperationActionType](docs/OperationActionType.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [SecurityInfo](docs/SecurityInfo.md)
 - [SecurityInfoOAuth2Info](docs/SecurityInfoOAuth2Info.md)
 - [SecurityInfoOAuth2InfoGrantType](docs/SecurityInfoOAuth2InfoGrantType.md)
 - [Self](docs/Self.md)
 - [SerializerType](docs/SerializerType.md)
 - [ServiceDependency](docs/ServiceDependency.md)
 - [TimeSourceStatus](docs/TimeSourceStatus.md)
 - [TimingCaps](docs/TimingCaps.md)
 - [TimingCapsNtpServers](docs/TimingCapsNtpServers.md)
 - [TimingCapsNtpServersAuthenticationOption](docs/TimingCapsNtpServersAuthenticationOption.md)
 - [TimingCapsNtpServersNtpServerAddrType](docs/TimingCapsNtpServersNtpServerAddrType.md)
 - [TimingCapsPtpMasters](docs/TimingCapsPtpMasters.md)
 - [TimingCapsTimeStamp](docs/TimingCapsTimeStamp.md)
 - [TrafficFilter](docs/TrafficFilter.md)
 - [TrafficRule](docs/TrafficRule.md)
 - [TrafficRuleAction](docs/TrafficRuleAction.md)
 - [TrafficRuleFilterType](docs/TrafficRuleFilterType.md)
 - [TrafficRuleState](docs/TrafficRuleState.md)
 - [TransportDependency](docs/TransportDependency.md)
 - [TransportDescriptor](docs/TransportDescriptor.md)
 - [TransportType](docs/TransportType.md)
 - [TunnelInfo](docs/TunnelInfo.md)
 - [TunnelInfoTunnelType](docs/TunnelInfoTunnelType.md)


## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com

