# Go API client for client

Application Mobility Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC021 Application Mobility API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/021/02.02.01_60/gs_MEC021v020201p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-ams](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-ams) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about application mobility in the network <p>**Note**<br>AdvantEDGE supports a selected subset of Application Mobility API endpoints (see below).

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 2.2.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/amsi/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AmsiApi* | [**AppMobilityServiceByIdDELETE**](docs/AmsiApi.md#appmobilityservicebyiddelete) | **Delete** /app_mobility_services/{appMobilityServiceId} |  deregister the individual application mobility service
*AmsiApi* | [**AppMobilityServiceByIdGET**](docs/AmsiApi.md#appmobilityservicebyidget) | **Get** /app_mobility_services/{appMobilityServiceId} | Retrieve information about this individual application mobility service
*AmsiApi* | [**AppMobilityServiceByIdPUT**](docs/AmsiApi.md#appmobilityservicebyidput) | **Put** /app_mobility_services/{appMobilityServiceId} |  update the existing individual application mobility service
*AmsiApi* | [**AppMobilityServiceGET**](docs/AmsiApi.md#appmobilityserviceget) | **Get** /app_mobility_services | Retrieve information about the registered application mobility service.
*AmsiApi* | [**AppMobilityServicePOST**](docs/AmsiApi.md#appmobilityservicepost) | **Post** /app_mobility_services | Create a new application mobility service for the service requester.
*AmsiApi* | [**Mec011AppTerminationPOST**](docs/AmsiApi.md#mec011appterminationpost) | **Post** /notifications/mec011/appTermination | MEC011 Application Termination notification for self termination
*AmsiApi* | [**SubByIdDELETE**](docs/AmsiApi.md#subbyiddelete) | **Delete** /subscriptions/{subscriptionId} | cancel the existing individual subscription
*AmsiApi* | [**SubByIdGET**](docs/AmsiApi.md#subbyidget) | **Get** /subscriptions/{subscriptionId} | Retrieve information about this subscription.
*AmsiApi* | [**SubByIdPUT**](docs/AmsiApi.md#subbyidput) | **Put** /subscriptions/{subscriptionId} | update the existing individual subscription.
*AmsiApi* | [**SubGET**](docs/AmsiApi.md#subget) | **Get** /subscriptions | Retrieve information about the subscriptions for this requestor.
*AmsiApi* | [**SubPOST**](docs/AmsiApi.md#subpost) | **Post** /subscriptions | Create a new subscription to Application Mobility Service notifications.
*UnsupportedApi* | [**AdjAppInstGET**](docs/UnsupportedApi.md#adjappinstget) | **Get** /queries/adjacent_app_instances | Retrieve information about this subscription.
*UnsupportedApi* | [**AppMobilityServiceDerPOST**](docs/UnsupportedApi.md#appmobilityservicederpost) | **Post** /app_mobility_services/{appMobilityServiceId}/deregister_task |  deregister the individual application mobility service
*UnsupportedApi* | [**NotificationPOST**](docs/UnsupportedApi.md#notificationpost) | **Post** /uri_provided_by_subscriber | delivers a notification from the AMS resource to the subscriber


## Documentation For Models

 - [AdjacentAppInfoNotification](docs/AdjacentAppInfoNotification.md)
 - [AdjacentAppInfoNotificationAdjacentAppInfo](docs/AdjacentAppInfoNotificationAdjacentAppInfo.md)
 - [AdjacentAppInfoSubscription](docs/AdjacentAppInfoSubscription.md)
 - [AdjacentAppInfoSubscriptionFilterCriteria](docs/AdjacentAppInfoSubscriptionFilterCriteria.md)
 - [AdjacentAppInfoSubscriptionLinks](docs/AdjacentAppInfoSubscriptionLinks.md)
 - [AdjacentAppInstanceInfo](docs/AdjacentAppInstanceInfo.md)
 - [AppMobilityServiceLevel](docs/AppMobilityServiceLevel.md)
 - [AppTerminationNotification](docs/AppTerminationNotification.md)
 - [AppTerminationNotificationLinks](docs/AppTerminationNotificationLinks.md)
 - [AssociateId](docs/AssociateId.md)
 - [AssociateIdType](docs/AssociateIdType.md)
 - [CommunicationInterface](docs/CommunicationInterface.md)
 - [CommunicationInterfaceIpAddresses](docs/CommunicationInterfaceIpAddresses.md)
 - [ContextTransferState](docs/ContextTransferState.md)
 - [ExpiryNotification](docs/ExpiryNotification.md)
 - [InlineNotification](docs/InlineNotification.md)
 - [InlineSubscription](docs/InlineSubscription.md)
 - [Link](docs/Link.md)
 - [LinkType](docs/LinkType.md)
 - [MecHostInformation](docs/MecHostInformation.md)
 - [MobilityProcedureNotification](docs/MobilityProcedureNotification.md)
 - [MobilityProcedureNotificationTargetAppInfo](docs/MobilityProcedureNotificationTargetAppInfo.md)
 - [MobilityProcedureSubscription](docs/MobilityProcedureSubscription.md)
 - [MobilityProcedureSubscriptionFilterCriteria](docs/MobilityProcedureSubscriptionFilterCriteria.md)
 - [MobilityProcedureSubscriptionLinks](docs/MobilityProcedureSubscriptionLinks.md)
 - [MobilityStatus](docs/MobilityStatus.md)
 - [OneOfInlineNotification](docs/OneOfInlineNotification.md)
 - [OneOfInlineSubscription](docs/OneOfInlineSubscription.md)
 - [OperationActionType](docs/OperationActionType.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [RegistrationInfo](docs/RegistrationInfo.md)
 - [RegistrationInfoDeviceInformation](docs/RegistrationInfoDeviceInformation.md)
 - [RegistrationInfoServiceConsumerId](docs/RegistrationInfoServiceConsumerId.md)
 - [SubscriptionLinkList](docs/SubscriptionLinkList.md)
 - [SubscriptionLinkListLinks](docs/SubscriptionLinkListLinks.md)
 - [SubscriptionLinkListSubscription](docs/SubscriptionLinkListSubscription.md)
 - [SubscriptionType](docs/SubscriptionType.md)
 - [TestNotification](docs/TestNotification.md)
 - [TestNotificationLinks](docs/TestNotificationLinks.md)
 - [TimeStamp](docs/TimeStamp.md)
 - [WebsockNotifConfig](docs/WebsockNotifConfig.md)


## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com

