/*
 * Copyright (c) 2024  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE V2X Information Service REST API
 *
 * V2X Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC030 V2XI API](.https://www.etsi.org/deliver/etsi_gs/MEC/001_099/030/03.02.01_60/) <p>[Copyright (c) ETSI 2024](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-vis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-vis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Note**<br>AdvantEDGE supports a selected subset of VIS API endpoints (see below) and a subset of subscription types...
 *
 * API version: 3.2.2
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

type PredictedQos struct {
	// Granularity of visited location. Measured in meters.
	LocationGranularity string `json:"locationGranularity"`

	NoticePeriod *TimeStamp `json:"noticePeriod,omitempty"`

	PredictionArea *PredictionArea `json:"predictionArea,omitempty"`
	// Indicates target of QoS prediction. Valid values:  1. SINGLE_UE_PREDICTION:  The predicted QoS is to be intended as journey-specific for a requesting vehicular UE.  2. E2E_APPLICATION_INSTANCE_PREDICTION: The E2E user plane link between two V2X application instances, where one instance relates to a single vehicular UE and the other instance to an application instance within another network, i.e. either another vehicular UE as in the V2N2V case, or an infrastructure element as in the V2N2I case.  Shall only be included in the request.
	PredictionTarget string `json:"predictionTarget"`

	Qos *Qos `json:"qos"`

	Routes []Routes `json:"routes,omitempty"`

	TimeGranularity *TimeStamp `json:"timeGranularity,omitempty"`
}
