/*
 * AdvantEDGE Location API
 *
 * Location Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC013 Location API](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/013/03.01.01_60/gs_mec013v030101p.pdf) <p>The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-loc-serv](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-loc-serv) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about Users (UE) and Zone locations <p>**Note**<br>AdvantEDGE supports all of Location API endpoints (see below).
 *
 * API version: 3.1.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

// A type containing zone status notification.
type ZoneStatusNotification struct {
	// Identifier of an access point (e.g. ap01). Shall be included when userNumEvent related with access point or operationStatus is included.
	AccessPointId string `json:"accessPointId,omitempty"`
	// Shall be set to \"ZoneStatusNotification\".
	NotificationType string `json:"notificationType"`

	OperationStatus *OperationStatus `json:"operationStatus,omitempty"`

	TimeStamp *TimeStamp `json:"timeStamp,omitempty"`
	// Shall be present when ZoneStatusSubscription includes upperNumberOfUsersZoneThreshold, lowerNumberOfUsersZoneThreshold, upperNumberOfUsersAPThreshold or lowerNumberOfUsersAPThreshold, and the number of users in a zone or an access point crosses the threshold defined in the subscription: 1 = OVER_ZONE_UPPER_THD. 2 = UNDER_ZONE_LOWER_THD. 3 = OVER_AP_UPPER_THD. 4 = UNDER_AP_LOWER_THD.
	UserNumEvent string `json:"userNumEvent,omitempty"`
	// The identity of the zone.
	ZoneId string `json:"zoneId"`

	// Shall be present when ZoneStatusSubscription includes specific thresholds.
	Links *SubscriptionLinks `json:"_links,omitempty"`
}
