/*
 * AdvantEDGE Location API
 *
 * Location Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC013 Location API](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/013/03.01.01_60/gs_mec013v030101p.pdf) <p>The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-loc-serv](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-loc-serv) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about Users (UE) and Zone locations <p>**Note**<br>AdvantEDGE supports all of Location API endpoints (see below).
 *
 * API version: 3.1.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

type UserDistanceSubscription struct {
	Links *Links `json:"_links,omitempty"`
	// URI exposed by the client on which to receive notifications via HTTP. See note 1.
	CallbackReference string `json:"callbackReference,omitempty"`
	// Check location immediately after establishing notification.
	CheckImmediate bool `json:"checkImmediate"`
	// A correlator that the client can use to tag this particular resource representation during a request to create a resource on the server. See note 2.
	ClientCorrelator string `json:"clientCorrelator,omitempty"`

	Criteria *DistanceCriteria `json:"criteria"`
	// Distance between users that shall be monitored. The unit is meter.
	Distance float32 `json:"distance"`

	ExpiryDeadline *TimeStamp `json:"expiryDeadline,omitempty"`
	// Contains addresses of users to monitor (e.g., ‘sip’ URI, ‘tel’ URI, ‘acr’ URI). Reference to a group could be provided here if supported by implementation. If the ReferenceAddress is specified, then the distance between each monitored user and reference user(s) will be monitored. If the ReferenceAddress is not present, then the distance between each pair of the monitored users will be monitored. Note that in that case there shall be at least two addresses specified here.
	MonitoredAddress []string `json:"monitoredAddress"`
	// If specified, indicates address of each user that will be used as reference users from which the distances towards monitored users indicated in the Addresses will be monitored (e.g., ‘sip’ URI, ‘tel’ URI, ‘acr’ URI). Reference to a group could be provided here if supported by implementation.
	ReferenceAddress []string `json:"referenceAddress,omitempty"`

	ReportingCtrl *ReportingCtrl `json:"reportingCtrl,omitempty"`
	// Set to TRUE by the service consumer to request a test notification via HTTP on the callbackReference URI, as specified in ETSI GS MEC 009 [4], clause 6.12a.
	RequestTestNotification bool `json:"requestTestNotification,omitempty"`
	// Shall be set to \"UserDistanceSubscription\".
	SubscriptionType string `json:"subscriptionType"`
	// Number of meters of acceptable error in tracking distance.
	TrackingAccuracy float32 `json:"trackingAccuracy"`

	WebsockNotifConfig *WebsockNotifConfig `json:"websockNotifConfig,omitempty"`
}
