/*
 * Copyright (c) 2024  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE V2X Information Service REST API
 *
 * The ETSI MEC ISG MEC040 Federation enablement API described using OpenAPI
 *
 * API version: 3.2.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

import (
	"fmt"
	"net/http"
	"strings"

	httpLog "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-http-logger"
	met "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-metrics"

	"github.com/gorilla/mux"
)

type HttpRoute struct {
	Name        string
	Method      string
	Pattern     string
	HandlerFunc http.HandlerFunc
}

type HttpRoutes []HttpRoute

func NewRouter() *mux.Router {
	var handler http.Handler
	router := mux.NewRouter().StrictSlash(true)
	for _, route := range routes {
		handler = route.HandlerFunc
		handler = Logger(handler, route.Name)
		handler = met.MetricsHandler(handler, sandboxName, serviceName)
		handler = httpLog.LogRx(handler)
		router.
			Methods(route.Method).
			Path(route.Pattern).
			Name(route.Name).
			Handler(handler)
	}

	// Path prefix router order is important
	// Service Api files
	handler = http.StripPrefix("/fed_enablement/v1/api/", http.FileServer(http.Dir("./api/")))
	router.
		PathPrefix("/fed_enablement/v1/api/").
		Name("Api").
		Handler(handler)
	// User supplied service API files
	handler = http.StripPrefix("/fed_enablement/v1/user-api/", http.FileServer(http.Dir("./user-api/")))
	router.
		PathPrefix("/fed_enablement/v1/user-api/").
		Name("UserApi").
		Handler(handler)

	return router
}

func Index(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello World from MEC 040!")
}

var routes = HttpRoutes{
	HttpRoute{
		"Index",
		"GET",
		"/fed_enablement/v1/",
		Index,
	},

	HttpRoute{
		"ServiceGET",
		strings.ToUpper("Get"),
		"/fed_enablement/v1/fed_resources/systems/{systemId}/services/{serviceId}",
		ServiceGET,
	},

	HttpRoute{
		"ServicesGET",
		strings.ToUpper("Get"),
		"/fed_enablement/v1/fed_resources/systems/{systemId}/services",
		ServicesGET,
	},

	HttpRoute{
		"SubscriptionDELETE",
		strings.ToUpper("Delete"),
		"/fed_enablement/v1/subscriptions/{subscriptionId}",
		SubscriptionDELETE,
	},

	HttpRoute{
		"SubscriptionGET",
		strings.ToUpper("Get"),
		"/fed_enablement/v1/subscriptions/{subscriptionId}",
		SubscriptionGET,
	},

	HttpRoute{
		"SubscriptionPOST",
		strings.ToUpper("Post"),
		"/fed_enablement/v1/subscriptions",
		SubscriptionPOST,
	},

	HttpRoute{
		"SubscriptionPUT",
		strings.ToUpper("Put"),
		"/fed_enablement/v1/subscriptions/{subscriptionId}",
		SubscriptionPUT,
	},

	HttpRoute{
		"SubscriptionsGET",
		strings.ToUpper("Get"),
		"/fed_enablement/v1/subscriptions",
		SubscriptionsGET,
	},

	HttpRoute{
		"SysteminfoByIdDELETE",
		strings.ToUpper("Delete"),
		"/fed_enablement/v1/fed_resources/systems/{systemId}",
		SysteminfoByIdDELETE,
	},

	HttpRoute{
		"SysteminfoByIdGET",
		strings.ToUpper("Get"),
		"/fed_enablement/v1/fed_resources/systems/{systemId}",
		SysteminfoByIdGET,
	},

	HttpRoute{
		"SysteminfoByIdPATCH",
		strings.ToUpper("Patch"),
		"/fed_enablement/v1/fed_resources/systems/{systemId}",
		SysteminfoByIdPATCH,
	},

	HttpRoute{
		"SysteminfoGET",
		strings.ToUpper("Get"),
		"/fed_enablement/v1/fed_resources/systems",
		SysteminfoGET,
	},

	HttpRoute{
		"SysteminfoPOST",
		strings.ToUpper("Post"),
		"/fed_enablement/v1/fed_resources/systems",
		SysteminfoPOST,
	},

	HttpRoute{
		"Mec011AppTerminationPOST",
		strings.ToUpper("Post"),
		"/vis/v2/notifications/mec011/appTermination",
		Mec011AppTerminationPOST,
	},
}
