/*
 * ETSI GS MEC 040 - MEC Federation enablement APIs
 *
 * The ETSI MEC ISG MEC040 Federation enablement API described using OpenAPI
 *
 * API version: 3.2.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

// Parameters related to use of OAuth 2.0. Shall be present in case OAuth 2.0 (see IETF RFC 6749 [13]) is supported to secure the provision of the service over the transport.
type OAuth2Info struct {
	// \"List of supported OAuth 2.0 grant types.\\nEach entry shall be one of the following permitted values:\\nOAUTH2_AUTHORIZATION_CODE (Authorization code grant type)\\nOAUTH2_IMPLICIT_GRANT\\n \\t(Implicit grant type)\\nOAUTH2_RESOURCE_OWNER\\n\\t(Resource owner password credentials grant type) \\nOAUTH2_CLIENT_CREDENTIALS\\n\\t(Client credentials grant type)\\nOnly the value \\\"OAUTH2_CLIENT_CREDENTIALS\\\" is supported in the present document. \"
	GrantTypes []string `json:"grantTypes"`
	// The token endpoint. Shall be present unless the grant type is OAUTH2_IMPLICIT_GRANT.
	TokenEndpoint string `json:"tokenEndpoint,omitempty"`
}
