/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Auth Service REST API
 *
 * This API provides microservice API authentication & authorization services <p>**Micro-service**<br>[meep-auth](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-auth) <p>**Type & Usage**<br>Platform interface used by ingress to authenticate & authorize microservice API access <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * API version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

import (
	"net/http"
)

func Authenticate(w http.ResponseWriter, r *http.Request) {
	asAuthenticate(w, r)
}

func Authorize(w http.ResponseWriter, r *http.Request) {
	asAuthorize(w, r)
}

func Login(w http.ResponseWriter, r *http.Request) {
	asLogin(w, r)
}

func LoginSupported(w http.ResponseWriter, r *http.Request) {
	asLoginSupported(w, r)
}

func LoginUser(w http.ResponseWriter, r *http.Request) {
	asLoginUser(w, r)
}

func Logout(w http.ResponseWriter, r *http.Request) {
	asLogout(w, r)
}

func TriggerWatchdog(w http.ResponseWriter, r *http.Request) {
	asTriggerWatchdog(w, r)
}
