# coding: utf-8

"""
    MEC Sandbox API

    The MEC Sandbox API described using OpenAPI  # noqa: E501

    OpenAPI spec version: 0.0.9
    Contact: cti_support@etsi.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class SandboxUEControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def sandbox_ue_controller_get(self, sandbox_name, **kwargs):  # noqa: E501
        """Get the list of the available UEs (e.g. \"Stationary UE\")  # noqa: E501

        This method retrieves the list of the available available UEs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sandbox_ue_controller_get(sandbox_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sandbox_name: Sandbox identifier (required)
        :return: list[UE]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.sandbox_ue_controller_get_with_http_info(sandbox_name, **kwargs)  # noqa: E501
        else:
            (data) = self.sandbox_ue_controller_get_with_http_info(sandbox_name, **kwargs)  # noqa: E501
            return data

    def sandbox_ue_controller_get_with_http_info(self, sandbox_name, **kwargs):  # noqa: E501
        """Get the list of the available UEs (e.g. \"Stationary UE\")  # noqa: E501

        This method retrieves the list of the available available UEs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sandbox_ue_controller_get_with_http_info(sandbox_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sandbox_name: Sandbox identifier (required)
        :return: list[UE]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sandbox_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sandbox_ue_controller_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sandbox_name' is set
        if ('sandbox_name' not in params or
                params['sandbox_name'] is None):
            raise ValueError("Missing the required parameter `sandbox_name` when calling `sandbox_ue_controller_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sandbox_name' in params:
            path_params['sandbox_name'] = params['sandbox_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/sandboxUeController/{sandbox_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UE]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def sandbox_ue_controller_patch(self, sandbox_name, user_equipment_id, user_equipment_value, **kwargs):  # noqa: E501
        """set the new value of the UE  # noqa: E501

        This method sets the new value of the UE.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sandbox_ue_controller_patch(sandbox_name, user_equipment_id, user_equipment_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sandbox_name: Sandbox identifier (required)
        :param str user_equipment_id: User equipmenet identifier (required)
        :param int user_equipment_value: It uniquely identifies a UE to set the new value (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.sandbox_ue_controller_patch_with_http_info(sandbox_name, user_equipment_id, user_equipment_value, **kwargs)  # noqa: E501
        else:
            (data) = self.sandbox_ue_controller_patch_with_http_info(sandbox_name, user_equipment_id, user_equipment_value, **kwargs)  # noqa: E501
            return data

    def sandbox_ue_controller_patch_with_http_info(self, sandbox_name, user_equipment_id, user_equipment_value, **kwargs):  # noqa: E501
        """set the new value of the UE  # noqa: E501

        This method sets the new value of the UE.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sandbox_ue_controller_patch_with_http_info(sandbox_name, user_equipment_id, user_equipment_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sandbox_name: Sandbox identifier (required)
        :param str user_equipment_id: User equipmenet identifier (required)
        :param int user_equipment_value: It uniquely identifies a UE to set the new value (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sandbox_name', 'user_equipment_id', 'user_equipment_value']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sandbox_ue_controller_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sandbox_name' is set
        if ('sandbox_name' not in params or
                params['sandbox_name'] is None):
            raise ValueError("Missing the required parameter `sandbox_name` when calling `sandbox_ue_controller_patch`")  # noqa: E501
        # verify the required parameter 'user_equipment_id' is set
        if ('user_equipment_id' not in params or
                params['user_equipment_id'] is None):
            raise ValueError("Missing the required parameter `user_equipment_id` when calling `sandbox_ue_controller_patch`")  # noqa: E501
        # verify the required parameter 'user_equipment_value' is set
        if ('user_equipment_value' not in params or
                params['user_equipment_value'] is None):
            raise ValueError("Missing the required parameter `user_equipment_value` when calling `sandbox_ue_controller_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sandbox_name' in params:
            path_params['sandbox_name'] = params['sandbox_name']  # noqa: E501

        query_params = []
        if 'user_equipment_id' in params:
            query_params.append(('user_equipment_id', params['user_equipment_id']))  # noqa: E501
        if 'user_equipment_value' in params:
            query_params.append(('user_equipment_value', params['user_equipment_value']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/sandboxUeController/{sandbox_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
