/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * MEEP Demo 4 API
 * Demo 4 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC016 usage
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * API version: 0.0.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

type ApplicationLocationAvailabilityAppInfo struct {
	// Identifies the version of the application descriptor. It is equivalent to the appDVersion defined in clause 6.2.1.2 of ETSI GS MEC 0102 [1].
	AppDVersion string `json:"appDVersion"`
	// Human readable description of the MEC application. The length of the value shall not exceed 128 characters.
	AppDescription string `json:"appDescription,omitempty"`
	// Name of the MEC application. The length of the value shall not exceed 32 characters.
	AppName string `json:"appName"`
	// URI of the application package. Shall be included in the request. The application package shall comply with the definitions in clause 6.2.1.2 of ETSI GS MEC 0102 [1].
	AppPackageSource string `json:"appPackageSource,omitempty"`
	// Provider of the MEC application. The length of the value shall not exceed 32 characters.
	AppProvider string `json:"appProvider"`
	// Software version of the MEC application. The length of the value shall not exceed 32 characters.
	AppSoftVersion string `json:"appSoftVersion,omitempty"`
	// MEC application location constraints.
	AvailableLocations []ApplicationLocationAvailabilityAppInfoAvailableLocations `json:"availableLocations,omitempty"`
}
