/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * MEEP Demo 4 API
 * Demo 4 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC016 usage
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * API version: 0.0.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

// Characteristics of the application. As defined below. The application characteristics relate to the system resources consumed by the application. A device application can use this information e.g. for estimating the cost of use of the application or for the expected user experience.
type ApplicationListAppInfoAppCharcs struct {
	// The required connection bandwidth in kbit/s for the use of the MEC application instance.
	Bandwidth int32 `json:"bandwidth,omitempty"`
	// The target round trip time in milliseconds supported by the MEC system for the MEC application instance.
	Latency int32 `json:"latency,omitempty"`
	// The maximum size in Mbytes of the memory resource expected to be used by the MEC application instance in the MEC system.
	Memory int32 `json:"memory,omitempty"`
	// Required service continuity mode for this application. Permitted values: 0 = SERVICE_CONTINUITY_NOT_REQUIRED. 1 = SERVICE_CONTINUITY_REQUIRED.
	ServiceCont int32 `json:"serviceCont,omitempty"`
	// The maximum size in Mbytes of the storage resource expected to be used by the MEC application instance in the MEC system.
	Storage int32 `json:"storage,omitempty"`
}
