/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * MEC Demo 3 API
 * Demo 3 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC011 and MEC021 usage
 *
 * OpenAPI spec version: 0.0.1
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 3.0.29
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/LocalityType', 'model/SerName', 'model/ServiceState'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./LocalityType'), require('./SerName'), require('./ServiceState'));
  } else {
    // Browser globals (root is window)
    if (!root.MecDemo3Api) {
      root.MecDemo3Api = {};
    }
    root.MecDemo3Api.ApplicationInstanceOfferedService = factory(root.MecDemo3Api.ApiClient, root.MecDemo3Api.LocalityType, root.MecDemo3Api.SerName, root.MecDemo3Api.ServiceState);
  }
}(this, function(ApiClient, LocalityType, SerName, ServiceState) {
  'use strict';

  /**
   * The ApplicationInstanceOfferedService model module.
   * @module model/ApplicationInstanceOfferedService
   * @version 0.0.1
   */

  /**
   * Constructs a new <code>ApplicationInstanceOfferedService</code>.
   * service offering
   * @alias module:model/ApplicationInstanceOfferedService
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>ApplicationInstanceOfferedService</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/ApplicationInstanceOfferedService} obj Optional instance to populate.
   * @return {module:model/ApplicationInstanceOfferedService} The populated <code>ApplicationInstanceOfferedService</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('serName'))
        obj.serName = SerName.constructFromObject(data['serName']);
      if (data.hasOwnProperty('id'))
        obj.id = ApiClient.convertToType(data['id'], 'String');
      if (data.hasOwnProperty('state'))
        obj.state = ServiceState.constructFromObject(data['state']);
      if (data.hasOwnProperty('scopeOfLocality'))
        obj.scopeOfLocality = LocalityType.constructFromObject(data['scopeOfLocality']);
      if (data.hasOwnProperty('consumedLocalOnly'))
        obj.consumedLocalOnly = ApiClient.convertToType(data['consumedLocalOnly'], 'Boolean');
    }
    return obj;
  }

  /**
   * @member {module:model/SerName} serName
   */
  exports.prototype.serName = undefined;

  /**
   * @member {String} id
   */
  exports.prototype.id = undefined;

  /**
   * @member {module:model/ServiceState} state
   */
  exports.prototype.state = undefined;

  /**
   * @member {module:model/LocalityType} scopeOfLocality
   */
  exports.prototype.scopeOfLocality = undefined;

  /**
   * Indicate whether the service can only be consumed by the MEC applications located in the same locality (as defined by scopeOfLocality) as this  service instance.
   * @member {Boolean} consumedLocalOnly
   */
  exports.prototype.consumedLocalOnly = undefined;

  return exports;

}));
