/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * MEC Demo 3 API
 * Demo 3 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC011 and MEC021 usage
 *
 * OpenAPI spec version: 0.0.1
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 3.0.29
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/SerInstanceId', 'model/SerName'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./SerInstanceId'), require('./SerName'));
  } else {
    // Browser globals (root is window)
    if (!root.MecDemo3Api) {
      root.MecDemo3Api = {};
    }
    root.MecDemo3Api.ApplicationInstanceDiscoveredServices = factory(root.MecDemo3Api.ApiClient, root.MecDemo3Api.SerInstanceId, root.MecDemo3Api.SerName);
  }
}(this, function(ApiClient, SerInstanceId, SerName) {
  'use strict';

  /**
   * The ApplicationInstanceDiscoveredServices model module.
   * @module model/ApplicationInstanceDiscoveredServices
   * @version 0.0.1
   */

  /**
   * Constructs a new <code>ApplicationInstanceDiscoveredServices</code>.
   * List of service name and their status
   * @alias module:model/ApplicationInstanceDiscoveredServices
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>ApplicationInstanceDiscoveredServices</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/ApplicationInstanceDiscoveredServices} obj Optional instance to populate.
   * @return {module:model/ApplicationInstanceDiscoveredServices} The populated <code>ApplicationInstanceDiscoveredServices</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('serName'))
        obj.serName = SerName.constructFromObject(data['serName']);
      if (data.hasOwnProperty('serInstanceId'))
        obj.serInstanceId = SerInstanceId.constructFromObject(data['serInstanceId']);
      if (data.hasOwnProperty('consumedLocalOnly'))
        obj.consumedLocalOnly = ApiClient.convertToType(data['consumedLocalOnly'], 'Boolean');
      if (data.hasOwnProperty('link'))
        obj.link = ApiClient.convertToType(data['link'], 'String');
      if (data.hasOwnProperty('version'))
        obj.version = ApiClient.convertToType(data['version'], 'String');
    }
    return obj;
  }

  /**
   * @member {module:model/SerName} serName
   */
  exports.prototype.serName = undefined;

  /**
   * @member {module:model/SerInstanceId} serInstanceId
   */
  exports.prototype.serInstanceId = undefined;

  /**
   * Indicate whether the service can only be consumed by the MEC applications located in the same locality (as defined by scopeOfLocality) as this  service instance.
   * @member {Boolean} consumedLocalOnly
   */
  exports.prototype.consumedLocalOnly = undefined;

  /**
   * @member {String} link
   */
  exports.prototype.link = undefined;

  /**
   * Service version
   * @member {String} version
   */
  exports.prototype.version = undefined;

  return exports;

}));
