/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * MEC Demo 3 API
 * Demo 3 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC011 and MEC021 usage
 *
 * OpenAPI spec version: 0.0.1
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 3.0.29
 *
 * Do not edit the class manually.
 *
 */

(function(factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/AdjacentAppInfoNotification', 'model/AdjacentAppInfoNotificationAdjacentAppInfo', 'model/AppTerminationNotification', 'model/AppTerminationNotificationLinks', 'model/ApplicationContextState', 'model/ApplicationInstance', 'model/ApplicationInstanceAmsLinkListSubscription', 'model/ApplicationInstanceAppTerminationSubscription', 'model/ApplicationInstanceDiscoveredServices', 'model/ApplicationInstanceOfferedService', 'model/ApplicationInstanceSerAvailabilitySubscription', 'model/ApplicationInstanceSubscriptions', 'model/AssociateId', 'model/AssociateIdType', 'model/CommunicationInterface', 'model/CommunicationInterfaceIpAddresses', 'model/ExpiryNotification', 'model/InlineNotification', 'model/Link', 'model/LinkType', 'model/LinkType1', 'model/LinkType2', 'model/LinkTypeConfirmTermination', 'model/LocalityType', 'model/MobilityProcedureNotification', 'model/MobilityProcedureNotificationTargetAppInfo', 'model/MobilityStatus', 'model/OneOfInlineNotification', 'model/OperationActionType', 'model/ProblemDetails', 'model/SerInstanceId', 'model/SerName', 'model/ServiceAvailabilityNotification', 'model/ServiceAvailabilityNotificationChangeType', 'model/ServiceAvailabilityNotificationServiceReferences', 'model/ServiceState', 'model/ServiceState1', 'model/Subscription', 'model/TimeStamp', 'api/FrontendApi', 'api/NotificationApi'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('./ApiClient'), require('./model/AdjacentAppInfoNotification'), require('./model/AdjacentAppInfoNotificationAdjacentAppInfo'), require('./model/AppTerminationNotification'), require('./model/AppTerminationNotificationLinks'), require('./model/ApplicationContextState'), require('./model/ApplicationInstance'), require('./model/ApplicationInstanceAmsLinkListSubscription'), require('./model/ApplicationInstanceAppTerminationSubscription'), require('./model/ApplicationInstanceDiscoveredServices'), require('./model/ApplicationInstanceOfferedService'), require('./model/ApplicationInstanceSerAvailabilitySubscription'), require('./model/ApplicationInstanceSubscriptions'), require('./model/AssociateId'), require('./model/AssociateIdType'), require('./model/CommunicationInterface'), require('./model/CommunicationInterfaceIpAddresses'), require('./model/ExpiryNotification'), require('./model/InlineNotification'), require('./model/Link'), require('./model/LinkType'), require('./model/LinkType1'), require('./model/LinkType2'), require('./model/LinkTypeConfirmTermination'), require('./model/LocalityType'), require('./model/MobilityProcedureNotification'), require('./model/MobilityProcedureNotificationTargetAppInfo'), require('./model/MobilityStatus'), require('./model/OneOfInlineNotification'), require('./model/OperationActionType'), require('./model/ProblemDetails'), require('./model/SerInstanceId'), require('./model/SerName'), require('./model/ServiceAvailabilityNotification'), require('./model/ServiceAvailabilityNotificationChangeType'), require('./model/ServiceAvailabilityNotificationServiceReferences'), require('./model/ServiceState'), require('./model/ServiceState1'), require('./model/Subscription'), require('./model/TimeStamp'), require('./api/FrontendApi'), require('./api/NotificationApi'));
  }
}(function(ApiClient, AdjacentAppInfoNotification, AdjacentAppInfoNotificationAdjacentAppInfo, AppTerminationNotification, AppTerminationNotificationLinks, ApplicationContextState, ApplicationInstance, ApplicationInstanceAmsLinkListSubscription, ApplicationInstanceAppTerminationSubscription, ApplicationInstanceDiscoveredServices, ApplicationInstanceOfferedService, ApplicationInstanceSerAvailabilitySubscription, ApplicationInstanceSubscriptions, AssociateId, AssociateIdType, CommunicationInterface, CommunicationInterfaceIpAddresses, ExpiryNotification, InlineNotification, Link, LinkType, LinkType1, LinkType2, LinkTypeConfirmTermination, LocalityType, MobilityProcedureNotification, MobilityProcedureNotificationTargetAppInfo, MobilityStatus, OneOfInlineNotification, OperationActionType, ProblemDetails, SerInstanceId, SerName, ServiceAvailabilityNotification, ServiceAvailabilityNotificationChangeType, ServiceAvailabilityNotificationServiceReferences, ServiceState, ServiceState1, Subscription, TimeStamp, FrontendApi, NotificationApi) {
  'use strict';

  /**
   * Demo_3_is_an_edge_application_that_can_be_used_with_AdvantEDGE_or_ETSI_MEC_Sandbox_to_demonstrate_MEC011_and_MEC021_usage.<br>
   * The <code>index</code> module provides access to constructors for all the classes which comprise the public API.
   * <p>
   * An AMD (recommended!) or CommonJS application will generally do something equivalent to the following:
   * <pre>
   * var MecDemo3Api = require('index'); // See note below*.
   * var xxxSvc = new MecDemo3Api.XxxApi(); // Allocate the API class we're going to use.
   * var yyyModel = new MecDemo3Api.Yyy(); // Construct a model instance.
   * yyyModel.someProperty = 'someValue';
   * ...
   * var zzz = xxxSvc.doSomething(yyyModel); // Invoke the service.
   * ...
   * </pre>
   * <em>*NOTE: For a top-level AMD script, use require(['index'], function(){...})
   * and put the application logic within the callback function.</em>
   * </p>
   * <p>
   * A non-AMD browser application (discouraged) might do something like this:
   * <pre>
   * var xxxSvc = new MecDemo3Api.XxxApi(); // Allocate the API class we're going to use.
   * var yyy = new MecDemo3Api.Yyy(); // Construct a model instance.
   * yyyModel.someProperty = 'someValue';
   * ...
   * var zzz = xxxSvc.doSomething(yyyModel); // Invoke the service.
   * ...
   * </pre>
   * </p>
   * @module index
   * @version 0.0.1
   */
  var exports = {
    /**
     * The ApiClient constructor.
     * @property {module:ApiClient}
     */
    ApiClient: ApiClient,
    /**
     * The AdjacentAppInfoNotification model constructor.
     * @property {module:model/AdjacentAppInfoNotification}
     */
    AdjacentAppInfoNotification: AdjacentAppInfoNotification,
    /**
     * The AdjacentAppInfoNotificationAdjacentAppInfo model constructor.
     * @property {module:model/AdjacentAppInfoNotificationAdjacentAppInfo}
     */
    AdjacentAppInfoNotificationAdjacentAppInfo: AdjacentAppInfoNotificationAdjacentAppInfo,
    /**
     * The AppTerminationNotification model constructor.
     * @property {module:model/AppTerminationNotification}
     */
    AppTerminationNotification: AppTerminationNotification,
    /**
     * The AppTerminationNotificationLinks model constructor.
     * @property {module:model/AppTerminationNotificationLinks}
     */
    AppTerminationNotificationLinks: AppTerminationNotificationLinks,
    /**
     * The ApplicationContextState model constructor.
     * @property {module:model/ApplicationContextState}
     */
    ApplicationContextState: ApplicationContextState,
    /**
     * The ApplicationInstance model constructor.
     * @property {module:model/ApplicationInstance}
     */
    ApplicationInstance: ApplicationInstance,
    /**
     * The ApplicationInstanceAmsLinkListSubscription model constructor.
     * @property {module:model/ApplicationInstanceAmsLinkListSubscription}
     */
    ApplicationInstanceAmsLinkListSubscription: ApplicationInstanceAmsLinkListSubscription,
    /**
     * The ApplicationInstanceAppTerminationSubscription model constructor.
     * @property {module:model/ApplicationInstanceAppTerminationSubscription}
     */
    ApplicationInstanceAppTerminationSubscription: ApplicationInstanceAppTerminationSubscription,
    /**
     * The ApplicationInstanceDiscoveredServices model constructor.
     * @property {module:model/ApplicationInstanceDiscoveredServices}
     */
    ApplicationInstanceDiscoveredServices: ApplicationInstanceDiscoveredServices,
    /**
     * The ApplicationInstanceOfferedService model constructor.
     * @property {module:model/ApplicationInstanceOfferedService}
     */
    ApplicationInstanceOfferedService: ApplicationInstanceOfferedService,
    /**
     * The ApplicationInstanceSerAvailabilitySubscription model constructor.
     * @property {module:model/ApplicationInstanceSerAvailabilitySubscription}
     */
    ApplicationInstanceSerAvailabilitySubscription: ApplicationInstanceSerAvailabilitySubscription,
    /**
     * The ApplicationInstanceSubscriptions model constructor.
     * @property {module:model/ApplicationInstanceSubscriptions}
     */
    ApplicationInstanceSubscriptions: ApplicationInstanceSubscriptions,
    /**
     * The AssociateId model constructor.
     * @property {module:model/AssociateId}
     */
    AssociateId: AssociateId,
    /**
     * The AssociateIdType model constructor.
     * @property {module:model/AssociateIdType}
     */
    AssociateIdType: AssociateIdType,
    /**
     * The CommunicationInterface model constructor.
     * @property {module:model/CommunicationInterface}
     */
    CommunicationInterface: CommunicationInterface,
    /**
     * The CommunicationInterfaceIpAddresses model constructor.
     * @property {module:model/CommunicationInterfaceIpAddresses}
     */
    CommunicationInterfaceIpAddresses: CommunicationInterfaceIpAddresses,
    /**
     * The ExpiryNotification model constructor.
     * @property {module:model/ExpiryNotification}
     */
    ExpiryNotification: ExpiryNotification,
    /**
     * The InlineNotification model constructor.
     * @property {module:model/InlineNotification}
     */
    InlineNotification: InlineNotification,
    /**
     * The Link model constructor.
     * @property {module:model/Link}
     */
    Link: Link,
    /**
     * The LinkType model constructor.
     * @property {module:model/LinkType}
     */
    LinkType: LinkType,
    /**
     * The LinkType1 model constructor.
     * @property {module:model/LinkType1}
     */
    LinkType1: LinkType1,
    /**
     * The LinkType2 model constructor.
     * @property {module:model/LinkType2}
     */
    LinkType2: LinkType2,
    /**
     * The LinkTypeConfirmTermination model constructor.
     * @property {module:model/LinkTypeConfirmTermination}
     */
    LinkTypeConfirmTermination: LinkTypeConfirmTermination,
    /**
     * The LocalityType model constructor.
     * @property {module:model/LocalityType}
     */
    LocalityType: LocalityType,
    /**
     * The MobilityProcedureNotification model constructor.
     * @property {module:model/MobilityProcedureNotification}
     */
    MobilityProcedureNotification: MobilityProcedureNotification,
    /**
     * The MobilityProcedureNotificationTargetAppInfo model constructor.
     * @property {module:model/MobilityProcedureNotificationTargetAppInfo}
     */
    MobilityProcedureNotificationTargetAppInfo: MobilityProcedureNotificationTargetAppInfo,
    /**
     * The MobilityStatus model constructor.
     * @property {module:model/MobilityStatus}
     */
    MobilityStatus: MobilityStatus,
    /**
     * The OneOfInlineNotification model constructor.
     * @property {module:model/OneOfInlineNotification}
     */
    OneOfInlineNotification: OneOfInlineNotification,
    /**
     * The OperationActionType model constructor.
     * @property {module:model/OperationActionType}
     */
    OperationActionType: OperationActionType,
    /**
     * The ProblemDetails model constructor.
     * @property {module:model/ProblemDetails}
     */
    ProblemDetails: ProblemDetails,
    /**
     * The SerInstanceId model constructor.
     * @property {module:model/SerInstanceId}
     */
    SerInstanceId: SerInstanceId,
    /**
     * The SerName model constructor.
     * @property {module:model/SerName}
     */
    SerName: SerName,
    /**
     * The ServiceAvailabilityNotification model constructor.
     * @property {module:model/ServiceAvailabilityNotification}
     */
    ServiceAvailabilityNotification: ServiceAvailabilityNotification,
    /**
     * The ServiceAvailabilityNotificationChangeType model constructor.
     * @property {module:model/ServiceAvailabilityNotificationChangeType}
     */
    ServiceAvailabilityNotificationChangeType: ServiceAvailabilityNotificationChangeType,
    /**
     * The ServiceAvailabilityNotificationServiceReferences model constructor.
     * @property {module:model/ServiceAvailabilityNotificationServiceReferences}
     */
    ServiceAvailabilityNotificationServiceReferences: ServiceAvailabilityNotificationServiceReferences,
    /**
     * The ServiceState model constructor.
     * @property {module:model/ServiceState}
     */
    ServiceState: ServiceState,
    /**
     * The ServiceState1 model constructor.
     * @property {module:model/ServiceState1}
     */
    ServiceState1: ServiceState1,
    /**
     * The Subscription model constructor.
     * @property {module:model/Subscription}
     */
    Subscription: Subscription,
    /**
     * The TimeStamp model constructor.
     * @property {module:model/TimeStamp}
     */
    TimeStamp: TimeStamp,
    /**
     * The FrontendApi service constructor.
     * @property {module:api/FrontendApi}
     */
    FrontendApi: FrontendApi,
    /**
     * The NotificationApi service constructor.
     * @property {module:api/NotificationApi}
     */
    NotificationApi: NotificationApi
  };

  return exports;
}));
