# Go API client for client

WLAN Access Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC028 WAI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/028/02.03.01_60/gs_MEC028v020301p.pdf) <p>[Copyright (c) ETSI 2024](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-wais](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-wais) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about WLAN access information in the network <p>**Note**<br>AdvantEDGE supports a selected subset of WAI API subscription types. <p>Supported subscriptions: <p> - AssocStaSubscription <p> - StaDataRateSubscription

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 2.3.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/wai/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*UnsupportedApi* | [**MeasurementLinkListMeasurementsGET**](docs/UnsupportedApi.md#measurementlinklistmeasurementsget) | **Get** /measurements | Retrieve information on measurements configuration
*UnsupportedApi* | [**MeasurementsDELETE**](docs/UnsupportedApi.md#measurementsdelete) | **Delete** /measurements/{measurementConfigId} | Cancel a measurement configuration
*UnsupportedApi* | [**MeasurementsGET**](docs/UnsupportedApi.md#measurementsget) | **Get** /measurements/{measurementConfigId} | Retrieve information on an existing measurement configuration
*UnsupportedApi* | [**MeasurementsPOST**](docs/UnsupportedApi.md#measurementspost) | **Post** /measurements | Create a new measurement configuration
*UnsupportedApi* | [**MeasurementsPUT**](docs/UnsupportedApi.md#measurementsput) | **Put** /measurements/{measurementConfigId} | Modify an existing measurement configuration
*WaiApi* | [**ApInfoGET**](docs/WaiApi.md#apinfoget) | **Get** /queries/ap/ap_information | Retrieve information on existing Access Points
*WaiApi* | [**Mec011AppTerminationPOST**](docs/WaiApi.md#mec011appterminationpost) | **Post** /notifications/mec011/appTermination | MEC011 Application Termination notification for self termination
*WaiApi* | [**StaInfoGET**](docs/WaiApi.md#stainfoget) | **Get** /queries/sta/sta_information | Retrieve information on existing Stations
*WaiApi* | [**SubscriptionLinkListSubscriptionsGET**](docs/WaiApi.md#subscriptionlinklistsubscriptionsget) | **Get** /subscriptions | Retrieve information on subscriptions for notifications
*WaiApi* | [**SubscriptionsDELETE**](docs/WaiApi.md#subscriptionsdelete) | **Delete** /subscriptions/{subscriptionId} | Cancel an existing subscription
*WaiApi* | [**SubscriptionsGET**](docs/WaiApi.md#subscriptionsget) | **Get** /subscriptions/{subscriptionId} | Retrieve information on current specific subscription
*WaiApi* | [**SubscriptionsPOST**](docs/WaiApi.md#subscriptionspost) | **Post** /subscriptions | Create a new subscription
*WaiApi* | [**SubscriptionsPUT**](docs/WaiApi.md#subscriptionsput) | **Put** /subscriptions/{subscriptionId} | Modify an existing subscription


## Documentation For Models

 - [ApAssociated](docs/ApAssociated.md)
 - [ApIdentity](docs/ApIdentity.md)
 - [ApInfo](docs/ApInfo.md)
 - [ApLocation](docs/ApLocation.md)
 - [AppTerminationNotification](docs/AppTerminationNotification.md)
 - [AppTerminationNotificationLinks](docs/AppTerminationNotificationLinks.md)
 - [AssocStaNotification](docs/AssocStaNotification.md)
 - [AssocStaSubscription](docs/AssocStaSubscription.md)
 - [AssocStaSubscriptionLinks](docs/AssocStaSubscriptionLinks.md)
 - [AssocStaSubscriptionNotificationEvent](docs/AssocStaSubscriptionNotificationEvent.md)
 - [BeaconReport](docs/BeaconReport.md)
 - [BeaconReportingConfig](docs/BeaconReportingConfig.md)
 - [BeaconRequestConfig](docs/BeaconRequestConfig.md)
 - [BssCapabilities](docs/BssCapabilities.md)
 - [BssLoad](docs/BssLoad.md)
 - [BssidInfo](docs/BssidInfo.md)
 - [ChannelLoad](docs/ChannelLoad.md)
 - [ChannelLoadConfig](docs/ChannelLoadConfig.md)
 - [CivicLocation](docs/CivicLocation.md)
 - [DmgCapabilities](docs/DmgCapabilities.md)
 - [EdmgCapabilities](docs/EdmgCapabilities.md)
 - [ExpiryNotification](docs/ExpiryNotification.md)
 - [ExpiryNotificationLinks](docs/ExpiryNotificationLinks.md)
 - [ExtBssLoad](docs/ExtBssLoad.md)
 - [GeoLocation](docs/GeoLocation.md)
 - [HeCapabilities](docs/HeCapabilities.md)
 - [HtCapabilities](docs/HtCapabilities.md)
 - [InlineNotification](docs/InlineNotification.md)
 - [InlineSubscription](docs/InlineSubscription.md)
 - [LinkType](docs/LinkType.md)
 - [MeasurementConfig](docs/MeasurementConfig.md)
 - [MeasurementConfigLinkList](docs/MeasurementConfigLinkList.md)
 - [MeasurementConfigLinkListMeasurementConfig](docs/MeasurementConfigLinkListMeasurementConfig.md)
 - [MeasurementConfigLinks](docs/MeasurementConfigLinks.md)
 - [MeasurementInfo](docs/MeasurementInfo.md)
 - [MeasurementReportNotification](docs/MeasurementReportNotification.md)
 - [MeasurementReportSubscription](docs/MeasurementReportSubscription.md)
 - [NeighborReport](docs/NeighborReport.md)
 - [NeighborReportConfig](docs/NeighborReportConfig.md)
 - [OBssLoad](docs/OBssLoad.md)
 - [OneOfInlineNotification](docs/OneOfInlineNotification.md)
 - [OneOfInlineSubscription](docs/OneOfInlineSubscription.md)
 - [OperationActionType](docs/OperationActionType.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [ReportedBeaconFrameInfo](docs/ReportedBeaconFrameInfo.md)
 - [ReportingReasonQoSCounters](docs/ReportingReasonQoSCounters.md)
 - [ReportingReasonStaCounters](docs/ReportingReasonStaCounters.md)
 - [Rssi](docs/Rssi.md)
 - [StaCounterTriggerCondition](docs/StaCounterTriggerCondition.md)
 - [StaDataRate](docs/StaDataRate.md)
 - [StaDataRateNotification](docs/StaDataRateNotification.md)
 - [StaDataRateSubscription](docs/StaDataRateSubscription.md)
 - [StaDataRateSubscriptionNotificationEvent](docs/StaDataRateSubscriptionNotificationEvent.md)
 - [StaIdentity](docs/StaIdentity.md)
 - [StaInfo](docs/StaInfo.md)
 - [StaStatistics](docs/StaStatistics.md)
 - [StaStatisticsConfig](docs/StaStatisticsConfig.md)
 - [StaStatisticsGroup2to9Data](docs/StaStatisticsGroup2to9Data.md)
 - [StaStatisticsGroupOneData](docs/StaStatisticsGroupOneData.md)
 - [StaStatisticsGroupZeroData](docs/StaStatisticsGroupZeroData.md)
 - [SubscriptionLinkList](docs/SubscriptionLinkList.md)
 - [SubscriptionLinkListLinks](docs/SubscriptionLinkListLinks.md)
 - [SubscriptionLinkListSubscription](docs/SubscriptionLinkListSubscription.md)
 - [TestNotification](docs/TestNotification.md)
 - [TestNotificationLinks](docs/TestNotificationLinks.md)
 - [TimeStamp](docs/TimeStamp.md)
 - [VhtCapabilities](docs/VhtCapabilities.md)
 - [WanMetrics](docs/WanMetrics.md)
 - [WebsockNotifConfig](docs/WebsockNotifConfig.md)
 - [WlanCapabilities](docs/WlanCapabilities.md)


## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com

