# Go API client for swagger

ETSI GS MEC 033 IoT API described using OpenAPI.

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 3.1.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen
For more information, please visit [https://forge.etsi.org/rep/mec/gs021-amsi-api](https://forge.etsi.org/rep/mec/gs021-amsi-api)

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/sandboxname/amsi/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*RegDevApi* | [**RegistereddevicesByIdDELETE**](docs/RegDevApi.md#registereddevicesbyiddelete) | **Delete** /registered_devices/{registeredDeviceId} | Deregister a device - see clause 5.2.6.
*RegDevApi* | [**RegistereddevicesByIdGET**](docs/RegDevApi.md#registereddevicesbyidget) | **Get** /registered_devices/{registeredDeviceId} | Retrieve information about a device - see clause 5.2.4.
*RegDevApi* | [**RegistereddevicesByIdPUT**](docs/RegDevApi.md#registereddevicesbyidput) | **Put** /registered_devices/{registeredDeviceId} | Update information about a  device including its association to a valid traffic rule - see clauses 5.2.5 and 5.4.3.
*RegDevApi* | [**RegistereddevicesGET**](docs/RegDevApi.md#registereddevicesget) | **Get** /registered_devices | Retrieve information about all devices with a valid traffic rule association - see clause 5.2.2.
*RegDevApi* | [**RegistereddevicesPOST**](docs/RegDevApi.md#registereddevicespost) | **Post** /registered_devices | Register a new device - see clause 5.2.3.
*RegIotPlatApi* | [**RegisterediotplatformsByIdDELETE**](docs/RegIotPlatApi.md#registerediotplatformsbyiddelete) | **Delete** /registered_iot_platforms/{registeredIotPlatformId} | Deregister a IoT platform - see clause 5.3.6.
*RegIotPlatApi* | [**RegisterediotplatformsByIdGET**](docs/RegIotPlatApi.md#registerediotplatformsbyidget) | **Get** /registered_iot_platforms/{registeredIotPlatformId} | Discover native services and obtain information about user transports provided by a IoT platform - see clauses 5.3.3 and 5.4.2.
*RegIotPlatApi* | [**RegisterediotplatformsByIdPUT**](docs/RegIotPlatApi.md#registerediotplatformsbyidput) | **Put** /registered_iot_platforms/{registeredIotPlatformId} | Update information about a IoT platform - see clause 5.3.5.
*RegIotPlatApi* | [**RegisterediotplatformsGET**](docs/RegIotPlatApi.md#registerediotplatformsget) | **Get** /registered_iot_platforms | Retrieve information about all IoT platforms - see clause 5.3.2.
*RegIotPlatApi* | [**RegisterediotplatformsPOST**](docs/RegIotPlatApi.md#registerediotplatformspost) | **Post** /registered_iot_platforms | Register a IoT platform - see clause 5.3.4.

## Documentation For Models

 - [Addresses](docs/Addresses.md)
 - [DeviceInfo](docs/DeviceInfo.md)
 - [DeviceSpecificMessageFormats](docs/DeviceSpecificMessageFormats.md)
 - [DownlinkInfo](docs/DownlinkInfo.md)
 - [EndPointInfo](docs/EndPointInfo.md)
 - [EventMsg](docs/EventMsg.md)
 - [ImplSpecificInfo](docs/ImplSpecificInfo.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InterfaceDescriptor](docs/InterfaceDescriptor.md)
 - [IotPlatformInfo](docs/IotPlatformInfo.md)
 - [KeyValuePair](docs/KeyValuePair.md)
 - [MbTransportInfo](docs/MbTransportInfo.md)
 - [OAuth2Info](docs/OAuth2Info.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [RegisteredDevicesBody](docs/RegisteredDevicesBody.md)
 - [RegisteredDevicesRegisteredDeviceIdBody](docs/RegisteredDevicesRegisteredDeviceIdBody.md)
 - [RegisteredIotPlatformsBody](docs/RegisteredIotPlatformsBody.md)
 - [RegisteredIotPlatformsRegisteredIotPlatformIdBody](docs/RegisteredIotPlatformsRegisteredIotPlatformIdBody.md)
 - [SecurityInfo](docs/SecurityInfo.md)
 - [SerializerType](docs/SerializerType.md)
 - [TrafficFilter](docs/TrafficFilter.md)
 - [TrafficRuleDescriptor](docs/TrafficRuleDescriptor.md)
 - [TransportInfo](docs/TransportInfo.md)
 - [TransportType](docs/TransportType.md)
 - [TunnelInfo](docs/TunnelInfo.md)
 - [UplinkMsg](docs/UplinkMsg.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

cti_support@etsi.org
