/*
 * ETSI GS MEC 040 - MEC Federation enablement APIs
 *
 * The ETSI MEC ISG MEC040 Federation enablement API described using OpenAPI
 *
 * API version: 3.2.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

// This type represents a subscription to the notifications from the MEC federator related to information update of the MEC systems in the MEC federation.
type SystemUpdateNotificationSubscription struct {
	// Shall be set to \"SystemUpdateNotificationSubscription\".
	SubscriptionType string `json:"subscriptionType"`
	// URI selected by the MEC orchestrator to receive notifications on the subscribed MEC system information updates in the MEC federation. This shall be included in both the request and the response.
	CallbackReference string `json:"callbackReference"`

	Links *Links `json:"links,omitempty"`
	// Identifier(s) to uniquely specify the target MEC system(s) for the subscription. If absent, the subscription should include all MEC systems in the MEC federation.
	SystemId []string `json:"systemId,omitempty"`

	ExpiryDeadline *TimeStamp `json:"expiryDeadline,omitempty"`
}
