/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Monitoring Engine REST API
 * This API provides AdvantEDGE microservice & scenario deployment status information collected in the Monitoring Engine. <p>**Micro-service**<br>[meep-mon-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-mon-engine) <p>**Type & Usage**<br>Platform interface to retrieve AdvantEDGE microservice & scenario deployment status information <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/PodsStatus'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../model/PodsStatus'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeMonitoringEngineRestApi) {
      root.AdvantEdgeMonitoringEngineRestApi = {};
    }
    root.AdvantEdgeMonitoringEngineRestApi.PodStatesApi = factory(root.AdvantEdgeMonitoringEngineRestApi.ApiClient, root.AdvantEdgeMonitoringEngineRestApi.PodsStatus);
  }
}(this, function(ApiClient, PodsStatus) {
  'use strict';

  /**
   * PodStates service.
   * @module api/PodStatesApi
   * @version 1.0.0
   */

  /**
   * Constructs a new PodStatesApi. 
   * @alias module:api/PodStatesApi
   * @class
   * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
   * default to {@link module:ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the getStates operation.
     * @callback module:api/PodStatesApi~getStatesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PodsStatus} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get pods states
     * Get status information of Core micro-services pods and Scenario pods
     * @param {Object} opts Optional parameters
     * @param {module:model/String} opts.type Pod type
     * @param {String} opts.sandbox Sandbox name
     * @param {module:model/String} opts._long Return detailed status information
     * @param {module:api/PodStatesApi~getStatesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PodsStatus}
     */
    this.getStates = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'type': opts['type'],
        'sandbox': opts['sandbox'],
        'long': opts['_long'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = PodsStatus;

      return this.apiClient.callApi(
        '/states', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
