/*
 * AdvantEDGE Location API
 *
 * Location Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC013 Location API](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/013/03.01.01_60/gs_mec013v030101p.pdf) <p>The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-loc-serv](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-loc-serv) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about Users (UE) and Zone locations <p>**Note**<br>AdvantEDGE supports all of Location API endpoints (see below).
 *
 * API version: 3.1.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

type UserAreaSubscription struct {
	Links *Links `json:"_links,omitempty"`
	// List of the users to be monitored.
	AddressList []string  `json:"addressList"`
	AreaDefine  *AreaInfo `json:"areaDefine"`
	// URI exposed by the client on which to receive notifications via HTTP. See note 1.
	CallbackReference string `json:"callbackReference,omitempty"`
	// A correlator that the client can use to tag this particular resource representation during a request to create a resource on the server. See note 2.
	ClientCorrelator string     `json:"clientCorrelator,omitempty"`
	ExpiryDeadline   *TimeStamp `json:"expiryDeadline,omitempty"`
	// List of user event values to generate notifications for (these apply to address specified).
	LocationEventCriteria []LocationEventType `json:"locationEventCriteria,omitempty"`
	ReportingCtrl         *ReportingCtrl      `json:"reportingCtrl,omitempty"`
	// This IE shall be set to true if a location estimate is required for each event report.
	ReportingLocationReq bool `json:"reportingLocationReq,omitempty"`
	// Set to TRUE by the service consumer to request a test notification via HTTP on the callbackReference URI, as specified in ETSI GS MEC 009 [4], clause 6.12a.
	RequestTestNotification bool `json:"requestTestNotification,omitempty"`
	// Shall be set to \"UserAreaSubscription\".
	SubscriptionType string `json:"subscriptionType"`
	// Number of meters of acceptable error.
	TrackingAccuracy   float32             `json:"trackingAccuracy"`
	WebsockNotifConfig *WebsockNotifConfig `json:"websockNotifConfig,omitempty"`
}
