/*
 * Copyright (c) 2025  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * ETSI GS MEC 033 IoT API
 *
 * ETSI GS MEC 033 IoT API described using OpenAPI.
 *
 * API version: 3.1.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

import (
	"fmt"
	"net/http"
	"strings"

	httpLog "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-http-logger"
	met "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-metrics"

	"github.com/gorilla/mux"
)

type HttpRoute struct {
	Name        string
	Method      string
	Pattern     string
	HandlerFunc http.HandlerFunc
}

type HttpRoutes []HttpRoute

func NewRouter() *mux.Router {
	var handler http.Handler
	router := mux.NewRouter().StrictSlash(true)
	for _, route := range routes {
		handler = route.HandlerFunc
		handler = Logger(handler, route.Name)
		handler = met.MetricsHandler(handler, sandboxName, serviceName)
		handler = httpLog.LogRx(handler)
		router.
			Methods(route.Method).
			Path(route.Pattern).
			Name(route.Name).
			Handler(handler)
	}

	// Path prefix router order is important
	// Service Api files
	handler = http.StripPrefix("/iots/v1/api/", http.FileServer(http.Dir("./api/")))
	router.
		PathPrefix("/iots/v1/api/").
		Name("Api").
		Handler(handler)
	// User supplied service API files
	handler = http.StripPrefix("/iots/v1/user-api/", http.FileServer(http.Dir("./user-api/")))
	router.
		PathPrefix("/iots/v1/user-api/").
		Name("UserApi").
		Handler(handler)

	return router
}

func Index(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello World from MEC 033!")
}

var routes = HttpRoutes{
	HttpRoute{
		"Index",
		"GET",
		"/iots/v1/",
		Index,
	},

	HttpRoute{
		"RegistereddevicesByIdDELETE",
		strings.ToUpper("Delete"),
		"/iots/v1/registered_devices/{registeredDeviceId}",
		RegistereddevicesByIdDELETE,
	},

	HttpRoute{
		"RegistereddevicesByIdGET",
		strings.ToUpper("Get"),
		"/iots/v1/registered_devices/{registeredDeviceId}",
		RegistereddevicesByIdGET,
	},

	HttpRoute{
		"RegistereddevicesByIdPUT",
		strings.ToUpper("Put"),
		"/iots/v1/registered_devices/{registeredDeviceId}",
		RegistereddevicesByIdPUT,
	},

	HttpRoute{
		"RegistereddevicesGET",
		strings.ToUpper("Get"),
		"/iots/v1/registered_devices",
		RegistereddevicesGET,
	},

	HttpRoute{
		"RegistereddevicesPOST",
		strings.ToUpper("Post"),
		"/iots/v1/registered_devices",
		RegistereddevicesPOST,
	},

	HttpRoute{
		"RegisterediotplatformsByIdDELETE",
		strings.ToUpper("Delete"),
		"/iots/v1/registered_iot_platforms/{registeredIotPlatformId}",
		RegisterediotplatformsByIdDELETE,
	},

	HttpRoute{
		"RegisterediotplatformsByIdGET",
		strings.ToUpper("Get"),
		"/iots/v1/registered_iot_platforms/{registeredIotPlatformId}",
		RegisterediotplatformsByIdGET,
	},

	HttpRoute{
		"RegisterediotplatformsByIdPUT",
		strings.ToUpper("Put"),
		"/iots/v1/registered_iot_platforms/{registeredIotPlatformId}",
		RegisterediotplatformsByIdPUT,
	},

	HttpRoute{
		"RegisterediotplatformsGET",
		strings.ToUpper("Get"),
		"/iots/v1/registered_iot_platforms",
		RegisterediotplatformsGET,
	},

	HttpRoute{
		"RegisterediotplatformsPOST",
		strings.ToUpper("Post"),
		"/iots/v1/registered_iot_platforms",
		RegisterediotplatformsPOST,
	},

	HttpRoute{
		"Mec011AppTerminationPOST",
		strings.ToUpper("Post"),
		"/iots/v1/notifications/mec011/appTermination",
		Mec011AppTerminationPOST,
	},
}
