/*
 * MEC Service Management API
 *
 * The ETSI MEC ISG MEC011 MEC Service Management API described using OpenAPI
 *
 * API version: 3.1.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

type EasProfile struct {
	// The identifier of the EAS
	EasId string `json:"easId"`

	EndPt *OneOfAppInfoEndpoint `json:"endPt"`
	// Identities of the Application Clients that can be served by the EAS
	AcIds []string `json:"acIds"`
	// Identifier of the ASP that provides the EAS.
	ProvId string `json:"provId,omitempty"`
	// The category or type of EAS.
	Type_ *CategoryRef `json:"type,omitempty"`
	// The availability schedule of the EAS.
	Scheds []string `json:"scheds"`
	// The list of geographical and topological areas that the EAS serves. ACs in the UE that are outside the area will not be served.
	SvcArea string `json:"svcArea,omitempty"`
	// Service characteristics provided by the EAS.
	SvcKpi string `json:"svcKpi,omitempty"`
	// level of service permissions supported by the EAS.
	PermLvl []string `json:"permLvl"`
	// Service features supported by the EAS.
	EasFeats []string `json:"easFeats"`
	// The ACR scenarios supported by the EAS for service continuity.
	SvcContSupp []string `json:"svcContSupp"`
	// List of DNAI(s) and the N6 traffic information associated with the EAS.
	AppLocs []string `json:"appLocs"`
	// The period indicating to the EES, how often the EES needs to check the EAS's availability after a successful registration.
	AvlRep int32 `json:"avlRep,omitempty"`
	// EAS status information.
	Status string `json:"status,omitempty"`
}
