/*
 * MEC Service Management API
 *
 * The ETSI MEC ISG MEC011 MEC Service Management API described using OpenAPI
 *
 * API version: 3.1.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

import (
	"time"
)

// EAS discovery request information.
type EasDiscoveryReq struct {
	RequestorId *RequestorId `json:"requestorId"`

	UeId string `json:"ueId,omitempty"`

	EasDiscoveryFilter *EasDiscoveryFilter `json:"easDiscoveryFilter,omitempty"`
	// Indicates if the EEC supports service continuity or not, also indicates which ACR scenarios are supported by the EEC.
	EecSvcContinuity []AcrScenario `json:"eecSvcContinuity,omitempty"`
	// Indicates if the EES supports service continuity or not, also indicates which ACR scenarios are supported by the EES.
	EesSvcContinuity []AcrScenario `json:"eesSvcContinuity,omitempty"`
	// Indicates if the EAS supports service continuity or not, also indicates which ACR scenarios are supported by the EAS.
	EasSvcContinuity []AcrScenario `json:"easSvcContinuity,omitempty"`

	LocInf *LocationInfo `json:"locInf,omitempty"`
	// Indicates if the EEC requires the EAS selection support from the EES (e.g., for constrained device). The default value false indicates the EAS selection is not required from the EES.
	EasSelSupInd bool `json:"easSelSupInd,omitempty"`

	SuppFeat string `json:"suppFeat,omitempty"`
	// Indicates to the EES whether the EAS instantiation triggering should be performed for the current request. The default value false indicates the EAS instantiation triggering should not be performed. The true value indicate the EAS instantiation triggering should be performed.
	EasIntTrigSup bool `json:"easIntTrigSup,omitempty"`

	PredictExpTime *time.Time `json:"predictExpTime,omitempty"`
}
