/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Sandbox Controller REST API
 * This API is the main Sandbox Controller API for scenario deployment & event injection <p>**Micro-service**<br>[meep-sandbox-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-sandbox-ctrl) <p>**Type & Usage**<br>Platform runtime interface to manage active scenarios and inject events in AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeSandboxControllerRestApi) {
      root.AdvantEdgeSandboxControllerRestApi = {};
    }
    root.AdvantEdgeSandboxControllerRestApi.DNConfig = factory(root.AdvantEdgeSandboxControllerRestApi.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';

  /**
   * The DNConfig model module.
   * @module model/DNConfig
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>DNConfig</code>.
   * Data Network Configuration
   * @alias module:model/DNConfig
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>DNConfig</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/DNConfig} obj Optional instance to populate.
   * @return {module:model/DNConfig} The populated <code>DNConfig</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('dnn'))
        obj.dnn = ApiClient.convertToType(data['dnn'], 'String');
      if (data.hasOwnProperty('ladn'))
        obj.ladn = ApiClient.convertToType(data['ladn'], 'Boolean');
      if (data.hasOwnProperty('ecsp'))
        obj.ecsp = ApiClient.convertToType(data['ecsp'], 'String');
    }
    return obj;
  }

  /**
   * Data Network Name
   * @member {String} dnn
   */
  exports.prototype.dnn = undefined;

  /**
   * true: Data network serves local area only false: Data network is not limited to local area
   * @member {Boolean} ladn
   */
  exports.prototype.ladn = undefined;

  /**
   * Edge Compute Service Provider
   * @member {String} ecsp
   */
  exports.prototype.ecsp = undefined;

  return exports;

}));
