/*
 * AdvantEDGE Location API
 *
 * Location Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC013 Location API](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/013/03.01.01_60/gs_mec013v030101p.pdf) <p>The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-loc-serv](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-loc-serv) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about Users (UE) and Zone locations <p>**Note**<br>AdvantEDGE supports all of Location API endpoints (see below).
 *
 * API version: 3.1.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

// This type represents the information related to a user attached to an access point associated to the MEC host, such access point is in scope of the Location Service instance.
type UserInfo struct {
	// Address of user (e.g. 'sip' URI, 'tel' URI, 'acr' URI) currently on the access point, see note 1.
	Address string `json:"address"`
	// The identity of the access point the user is currently on, see note 1.
	AccessPointId string `json:"AccessPointId,omitempty"`
	// The identity of the zone the user is currently within, see note 1.
	ZoneId string `json:"zoneId"`
	// Self-referring URL, see note 1.
	ResourceURL  string        `json:"resourceURL"`
	Timestamp    *TimeStamp    `json:"timestamp"`
	LocationInfo *LocationInfo `json:"locationInfo,omitempty"`
	CivicInfo    *CivicAddress `json:"civicInfo,omitempty"`
	// Reserved for future use.
	AncillaryInfo        string                `json:"ancillaryInfo,omitempty"`
	RelativeLocationInfo *RelativeLocationInfo `json:"relativeLocationInfo,omitempty"`
}
