/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE GIS Engine REST API
 * This API allows to control geo-spatial behavior and simulation. <p>**Micro-service**<br>[meep-gis-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-gis-engine) <p>**Type & Usage**<br>Platform runtime interface to control geo-spatial behavior and simulation <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/AutomationState', 'model/AutomationStateList', 'model/CoordinatePower', 'model/CoordinatePowerList', 'model/Distance', 'model/GeoCoordinate', 'model/GeoCoordinateList', 'model/GeoData', 'model/GeoDataAssetList', 'model/LineString', 'model/Point', 'model/TargetPoint', 'model/TargetRange', 'model/WithinRange', 'model/GeoDataAsset', 'api/AutomationApi', 'api/GeospatialDataApi'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('./ApiClient'), require('./model/AutomationState'), require('./model/AutomationStateList'), require('./model/CoordinatePower'), require('./model/CoordinatePowerList'), require('./model/Distance'), require('./model/GeoCoordinate'), require('./model/GeoCoordinateList'), require('./model/GeoData'), require('./model/GeoDataAssetList'), require('./model/LineString'), require('./model/Point'), require('./model/TargetPoint'), require('./model/TargetRange'), require('./model/WithinRange'), require('./model/GeoDataAsset'), require('./api/AutomationApi'), require('./api/GeospatialDataApi'));
  }
}(function(ApiClient, AutomationState, AutomationStateList, CoordinatePower, CoordinatePowerList, Distance, GeoCoordinate, GeoCoordinateList, GeoData, GeoDataAssetList, LineString, Point, TargetPoint, TargetRange, WithinRange, GeoDataAsset, AutomationApi, GeospatialDataApi) {
  'use strict';

  /**
   * This_API_allows_to_control_geo_spatial_behavior_and_simulation__pMicro_servicebr_meep_gis_engine_httpsgithub_comInterDigitalIncAdvantEDGEtreemastergo_appsmeep_gis_engine_pType__UsagebrPlatform_runtime_interface_to_control_geo_spatial_behavior_and_simulation_pDetailsbrAPI_details_available_at__your_AdvantEDGE_ip_addressapi_.<br>
   * The <code>index</code> module provides access to constructors for all the classes which comprise the public API.
   * <p>
   * An AMD (recommended!) or CommonJS application will generally do something equivalent to the following:
   * <pre>
   * var AdvantEdgeGisEngineRestApi = require('index'); // See note below*.
   * var xxxSvc = new AdvantEdgeGisEngineRestApi.XxxApi(); // Allocate the API class we're going to use.
   * var yyyModel = new AdvantEdgeGisEngineRestApi.Yyy(); // Construct a model instance.
   * yyyModel.someProperty = 'someValue';
   * ...
   * var zzz = xxxSvc.doSomething(yyyModel); // Invoke the service.
   * ...
   * </pre>
   * <em>*NOTE: For a top-level AMD script, use require(['index'], function(){...})
   * and put the application logic within the callback function.</em>
   * </p>
   * <p>
   * A non-AMD browser application (discouraged) might do something like this:
   * <pre>
   * var xxxSvc = new AdvantEdgeGisEngineRestApi.XxxApi(); // Allocate the API class we're going to use.
   * var yyy = new AdvantEdgeGisEngineRestApi.Yyy(); // Construct a model instance.
   * yyyModel.someProperty = 'someValue';
   * ...
   * var zzz = xxxSvc.doSomething(yyyModel); // Invoke the service.
   * ...
   * </pre>
   * </p>
   * @module index
   * @version 1.0.0
   */
  var exports = {
    /**
     * The ApiClient constructor.
     * @property {module:ApiClient}
     */
    ApiClient: ApiClient,
    /**
     * The AutomationState model constructor.
     * @property {module:model/AutomationState}
     */
    AutomationState: AutomationState,
    /**
     * The AutomationStateList model constructor.
     * @property {module:model/AutomationStateList}
     */
    AutomationStateList: AutomationStateList,
    /**
     * The CoordinatePower model constructor.
     * @property {module:model/CoordinatePower}
     */
    CoordinatePower: CoordinatePower,
    /**
     * The CoordinatePowerList model constructor.
     * @property {module:model/CoordinatePowerList}
     */
    CoordinatePowerList: CoordinatePowerList,
    /**
     * The Distance model constructor.
     * @property {module:model/Distance}
     */
    Distance: Distance,
    /**
     * The GeoCoordinate model constructor.
     * @property {module:model/GeoCoordinate}
     */
    GeoCoordinate: GeoCoordinate,
    /**
     * The GeoCoordinateList model constructor.
     * @property {module:model/GeoCoordinateList}
     */
    GeoCoordinateList: GeoCoordinateList,
    /**
     * The GeoData model constructor.
     * @property {module:model/GeoData}
     */
    GeoData: GeoData,
    /**
     * The GeoDataAssetList model constructor.
     * @property {module:model/GeoDataAssetList}
     */
    GeoDataAssetList: GeoDataAssetList,
    /**
     * The LineString model constructor.
     * @property {module:model/LineString}
     */
    LineString: LineString,
    /**
     * The Point model constructor.
     * @property {module:model/Point}
     */
    Point: Point,
    /**
     * The TargetPoint model constructor.
     * @property {module:model/TargetPoint}
     */
    TargetPoint: TargetPoint,
    /**
     * The TargetRange model constructor.
     * @property {module:model/TargetRange}
     */
    TargetRange: TargetRange,
    /**
     * The WithinRange model constructor.
     * @property {module:model/WithinRange}
     */
    WithinRange: WithinRange,
    /**
     * The GeoDataAsset model constructor.
     * @property {module:model/GeoDataAsset}
     */
    GeoDataAsset: GeoDataAsset,
    /**
     * The AutomationApi service constructor.
     * @property {module:api/AutomationApi}
     */
    AutomationApi: AutomationApi,
    /**
     * The GeospatialDataApi service constructor.
     * @property {module:api/GeospatialDataApi}
     */
    GeospatialDataApi: GeospatialDataApi
  };

  return exports;
}));
