/*
 * MEC Sandbox API
 *
 * The MEC Sandbox API described using OpenAPI
 *
 * API version: 0.0.7
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

import (
	"fmt"
	"net/http"
	"strings"

	"github.com/gorilla/mux"
)

type Route struct {
	Name        string
	Method      string
	Pattern     string
	HandlerFunc http.HandlerFunc
}

type Routes []Route

func NewRouter() *mux.Router {
	router := mux.NewRouter().StrictSlash(true)
	for _, route := range routes {
		var handler http.Handler = route.HandlerFunc
		handler = Logger(handler, route.Name)

		router.
			Methods(route.Method).
			Path(route.Pattern).
			Name(route.Name).
			Handler(handler)
	}

	return router
}

func Index(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello World!")
}

var routes = Routes{
	Route{
		"Index",
		"GET",
		"/sandbox-api/v1/",
		Index,
	},

	Route{
		"Login",
		strings.ToUpper("Post"),
		"/sandbox-api/v1/login",
		Login,
	},

	Route{
		"GetNamespace",
		strings.ToUpper("Get"),
		"/sandbox-api/v1/namespace",
		GetNamespace,
	},

	Route{
		"Logout",
		strings.ToUpper("Post"),
		"/sandbox-api/v1/logout",
		Logout,
	},

	Route{
		"SandboxAppInstancesDELETE",
		strings.ToUpper("Delete"),
		"/sandbox-api/v1/sandboxAppInstances/{sandbox_name}/{app_instance_id}",
		SandboxAppInstancesDELETE,
	},

	Route{
		"SandboxAppInstancesGET",
		strings.ToUpper("Get"),
		"/sandbox-api/v1/sandboxAppInstances/{sandbox_name}",
		SandboxAppInstancesGET,
	},

	Route{
		"SandboxAppInstancesPOST",
		strings.ToUpper("Post"),
		"/sandbox-api/v1/sandboxAppInstances/{sandbox_name}",
		SandboxAppInstancesPOST,
	},

	Route{
		"SandboxLogsSubscriptionsDELETE",
		strings.ToUpper("Delete"),
		"/sandbox-api/v1/sandboxLogsSubscriptions/{sandbox_name}/{subscription_reference}",
		SandboxLogsSubscriptionsDELETE,
	},

	Route{
		"SandboxLogsSubscriptionsPOST",
		strings.ToUpper("Post"),
		"/sandbox-api/v1/sandboxLogsSubscriptions/{sandbox_name}",
		SandboxLogsSubscriptionsPOST,
	},

	Route{
		"SandboxMecServicesGET",
		strings.ToUpper("Get"),
		"/sandbox-api/v1/sandboxMecServices/{sandbox_name}",
		SandboxMecServicesGET,
	},

	Route{
		"SandboxIndividualNetworkScenariosGET",
		strings.ToUpper("Get"),
		"/sandbox-api/v1/sandboxNetworkScenarios/{sandbox_name}",
		SandboxIndividualNetworkScenariosGET,
	},

	Route{
		"SandboxNetworkScenarioDELETE",
		strings.ToUpper("Delete"),
		"/sandbox-api/v1/sandboxNetworkScenarios/{sandbox_name}/{network_scenario_id}",
		SandboxNetworkScenarioDELETE,
	},

	Route{
		"SandboxNetworkScenarioPOST",
		strings.ToUpper("Post"),
		"/sandbox-api/v1/sandboxNetworkScenarios/{sandbox_name}",
		SandboxNetworkScenarioPOST,
	},

	Route{
		"SandboxNetworkScenariosGET",
		strings.ToUpper("Get"),
		"/sandbox-api/v1/sandboxNetworkScenarios",
		SandboxNetworkScenariosGET,
	},

	Route{
		"SandboxUeControllerGET",
		strings.ToUpper("Get"),
		"/sandbox-api/v1/sandboxUeController/{sandbox_name}",
		SandboxUeControllerGET,
	},

	Route{
		"SandboxUeControllerPATCH",
		strings.ToUpper("Patch"),
		"/sandbox-api/v1/sandboxUeController/{sandbox_name}",
		SandboxUeControllerPATCH,
	},

	Route{
		"ApiConsoleLogsGET",
		strings.ToUpper("Get"),
		"/sandbox-api/v1/apiConsoleLogs/{sandbox_name}",
		ApiConsoleLogsGET,
	},
}
