/*
 * MEC Service Management API
 *
 * The ETSI MEC ISG MEC011 MEC Service Management API described using OpenAPI
 *
 * API version: 3.1.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

// Represents the ACR scenarios supported by EES.   Possible values are: - EEC_INITIATED: Represents the EEC initiated ACR scenario. - EEC_EXECUTED_VIA_SOURCE_EES: Represents the EEC ACR scenario executed via the S-EES. - EEC_EXECUTED_VIA_TARGET_EES: Represents the EEC ACR scenario executed via the T-EES. - SOURCE_EAS_DECIDED: Represents the EEC ACR scenario where the S-EAS decides to perform   ACR. - SOURCE_EES_EXECUTED: Represents the EEC ACR scenario where S-EES executes the ACR. - EEL_MANAGED_ACR: Represents the EEC ACR scenario where the ACR is managed by the   Edge Enabler Layer.
type AcrScenario string

// Enum values for ACRScenarioEnum.
const (
	EEC_INITIATED               AcrScenario = "EEC_INITIATED"
	EEC_EXECUTED_VIA_SOURCE_EES AcrScenario = "EEC_EXECUTED_VIA_SOURCE_EES"
	EEC_EXECUTED_VIA_TARGET_EES AcrScenario = "EEC_EXECUTED_VIA_TARGET_EES"
	SOURCE_EAS_DECIDED          AcrScenario = "SOURCE_EAS_DECIDED"
	SOURCE_EES_EXECUTED         AcrScenario = "SOURCE_EES_EXECUTED"
	EEL_MANAGED_ACR             AcrScenario = "EEL_MANAGED_ACR"
)
