#!/bin/bash

#set -e
set -vx

# Get full path to script directory
SCRIPT=$(readlink -f "$0")
BASEDIR=$(dirname "$SCRIPT")

echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ">>> Stopping UT environment"
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ""

helm ls --short | grep meep-ut | xargs -L1 helm uninstall

echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ">>> Stopping meep-gis-asset stub"
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ""

PWDX=`ps aux | grep "exe/system_test_http_stub" | grep -v grep | awk {'print$2'}`
if [ ! -z "$PWDX" ]
then
    kill $PWDX
fi
