/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE WLAN Access Information API
 *
 * WLAN Access Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC028 WAI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/028/02.02.01_60/gs_MEC028v020201p.pdf) <p>[Copyright (c) ETSI 2020](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-wais](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-wais) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about WLAN access information in the network <p>**Note**<br>AdvantEDGE supports a selected subset of WAI API subscription types. <p>Supported subscriptions: <p> - AssocStaSubscription <p> - StaDataRateSubscription
 *
 * API version: 2.2.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

type BeaconReport struct {
	// The Antenna ID field contains the identifying number for the antenna(s) used for this measurement. Antenna ID is defined in section 9.4.2.40 of IEEE 802.11-2016 [8].
	AntennaId int32 `json:"antennaId,omitempty"`
	// Indicates the BSSID of the BSS for which a beacon report has been received.
	Bssid string `json:"bssid"`
	// Channel number where the beacon was received.
	Channel int32 `json:"channel"`
	// Measurement ID of the Measurement configuration applied to this Beacon Report.
	MeasurementId string `json:"measurementId"`
	// Operating Class field indicates an operating class value as defined in Annex E within IEEE 802.11-2016 [8].
	OperatingClass int32 `json:"operatingClass"`
	// The Parent TSF field contains the lower 4 octets of the measuring STA's TSF timer value at the start of reception of the first octet of the timestamp field of the reported Beacon, Measurement Pilot, or Probe Response frame at the time the Beacon, Measurement Pilot, or Probe Response frame being reported was received.
	ParentTsf int32 `json:"parentTsf,omitempty"`
	// RCPI indicates the received channel power of the Beacon, Measurement Pilot, or Probe Response frame, which is a logarithmic function of the received signal power, as defined in section 9.4.2.38 of IEEE 802.11-2016 [8].
	Rcpi              int32                    `json:"rcpi,omitempty"`
	ReportedFrameInfo *ReportedBeaconFrameInfo `json:"reportedFrameInfo"`
	// RSNI indicates the received signal-to-noise indication for the Beacon, Measurement Pilot, or Probe Response frame, as described in section 9.4.2.41 of IEEE 802.11-2016 [8].
	Rsni int32 `json:"rsni,omitempty"`
	// The SSID subelement indicates the ESS or IBSS for which a beacon report is received.
	Ssid  string       `json:"ssid,omitempty"`
	StaId *StaIdentity `json:"staId,omitempty"`
}
