# Go API client for swagger

V2X Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC030 V2XI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/030/02.02.01_60/gs_MEC030v020201p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-vis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-vis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Note**<br>AdvantEDGE supports a selected subset of RNI API endpoints (see below) and a subset of subscription types.

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 2.2.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/vis/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*UnsupportedApi* | [**IndividualSubscriptionDELETE**](docs/UnsupportedApi.md#individualsubscriptiondelete) | **Delete** /subscriptions/{subscriptionId} | Used to cancel the existing subscription.
*UnsupportedApi* | [**IndividualSubscriptionGET**](docs/UnsupportedApi.md#individualsubscriptionget) | **Get** /subscriptions/{subscriptionId} | Retrieve information about this subscription.
*UnsupportedApi* | [**IndividualSubscriptionPUT**](docs/UnsupportedApi.md#individualsubscriptionput) | **Put** /subscriptions/{subscriptionId} | Used to update the existing subscription.
*UnsupportedApi* | [**ProvInfoGET**](docs/UnsupportedApi.md#provinfoget) | **Get** /queries/pc5_provisioning_info | Query provisioning information for V2X communication over PC5.
*UnsupportedApi* | [**ProvInfoUuMbmsGET**](docs/UnsupportedApi.md#provinfouumbmsget) | **Get** /queries/uu_mbms_provisioning_info | retrieve information required for V2X communication over Uu MBMS.
*UnsupportedApi* | [**ProvInfoUuUnicastGET**](docs/UnsupportedApi.md#provinfouuunicastget) | **Get** /queries/uu_unicast_provisioning_info | Used to query provisioning information for V2X communication over Uu unicast.
*UnsupportedApi* | [**SubGET**](docs/UnsupportedApi.md#subget) | **Get** /subscriptions | Request information about the subscriptions for this requestor.
*UnsupportedApi* | [**SubPOST**](docs/UnsupportedApi.md#subpost) | **Post** /subscriptions |  create a new subscription to VIS notifications.
*UnsupportedApi* | [**V2xMessagePOST**](docs/UnsupportedApi.md#v2xmessagepost) | **Post** /publish_v2x_message | Used to publish a V2X message.
*V2xiApi* | [**Mec011AppTerminationPOST**](docs/V2xiApi.md#mec011appterminationpost) | **Post** /notifications/mec011/appTermination | MEC011 Application Termination notification for self termination
*V2xiApi* | [**PredictedQosPOST**](docs/V2xiApi.md#predictedqospost) | **Post** /provide_predicted_qos | Request the predicted QoS correspondent to potential routes of a vehicular UE.

## Documentation For Models

 - [AppTerminationNotification](docs/AppTerminationNotification.md)
 - [AppTerminationNotificationLinks](docs/AppTerminationNotificationLinks.md)
 - [Body](docs/Body.md)
 - [Body1](docs/Body1.md)
 - [CellId](docs/CellId.md)
 - [Earfcn](docs/Earfcn.md)
 - [Ecgi](docs/Ecgi.md)
 - [FddInfo](docs/FddInfo.md)
 - [LinkType](docs/LinkType.md)
 - [Links](docs/Links.md)
 - [LocationInfo](docs/LocationInfo.md)
 - [LocationInfoGeoArea](docs/LocationInfoGeoArea.md)
 - [MsgType](docs/MsgType.md)
 - [OneOfbody](docs/OneOfbody.md)
 - [OneOfbody1](docs/OneOfbody1.md)
 - [OperationActionType](docs/OperationActionType.md)
 - [Pc5NeighbourCellInfo](docs/Pc5NeighbourCellInfo.md)
 - [Pc5ProvisioningInfo](docs/Pc5ProvisioningInfo.md)
 - [Pc5ProvisioningInfoProInfoPc5](docs/Pc5ProvisioningInfoProInfoPc5.md)
 - [Plmn](docs/Plmn.md)
 - [PredictedQos](docs/PredictedQos.md)
 - [PredictedQosRoutes](docs/PredictedQosRoutes.md)
 - [PredictedQosRoutesRouteInfo](docs/PredictedQosRoutesRouteInfo.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [ProvChgPc5Notification](docs/ProvChgPc5Notification.md)
 - [ProvChgPc5Subscription](docs/ProvChgPc5Subscription.md)
 - [ProvChgPc5SubscriptionFilterCriteria](docs/ProvChgPc5SubscriptionFilterCriteria.md)
 - [ProvChgUuMbmsNotification](docs/ProvChgUuMbmsNotification.md)
 - [ProvChgUuMbmsSubscription](docs/ProvChgUuMbmsSubscription.md)
 - [ProvChgUuMbmsSubscriptionFilterCriteria](docs/ProvChgUuMbmsSubscriptionFilterCriteria.md)
 - [ProvChgUuUniNotification](docs/ProvChgUuUniNotification.md)
 - [ProvChgUuUniSubscription](docs/ProvChgUuUniSubscription.md)
 - [ProvChgUuUniSubscriptionFilterCriteria](docs/ProvChgUuUniSubscriptionFilterCriteria.md)
 - [SubscriptionLinkList](docs/SubscriptionLinkList.md)
 - [SubscriptionLinkListLinks](docs/SubscriptionLinkListLinks.md)
 - [SubscriptionLinkListLinksSubscriptions](docs/SubscriptionLinkListLinksSubscriptions.md)
 - [SystemInformationBlockType21](docs/SystemInformationBlockType21.md)
 - [TddInfo](docs/TddInfo.md)
 - [TestNotification](docs/TestNotification.md)
 - [TestNotificationLinks](docs/TestNotificationLinks.md)
 - [TimeStamp](docs/TimeStamp.md)
 - [TransmissionBandwidth](docs/TransmissionBandwidth.md)
 - [TransmissionBandwidthTransmissionBandwidth](docs/TransmissionBandwidthTransmissionBandwidth.md)
 - [UuMbmsNeighbourCellInfo](docs/UuMbmsNeighbourCellInfo.md)
 - [UuMbmsProvisioningInfo](docs/UuMbmsProvisioningInfo.md)
 - [UuMbmsProvisioningInfoProInfoUuMbms](docs/UuMbmsProvisioningInfoProInfoUuMbms.md)
 - [UuUniNeighbourCellInfo](docs/UuUniNeighbourCellInfo.md)
 - [UuUnicastProvisioningInfo](docs/UuUnicastProvisioningInfo.md)
 - [UuUnicastProvisioningInfoProInfoUuUnicast](docs/UuUnicastProvisioningInfoProInfoUuUnicast.md)
 - [V2xApplicationServer](docs/V2xApplicationServer.md)
 - [V2xMsgNotification](docs/V2xMsgNotification.md)
 - [V2xMsgNotificationLinks](docs/V2xMsgNotificationLinks.md)
 - [V2xMsgPublication](docs/V2xMsgPublication.md)
 - [V2xMsgSubscription](docs/V2xMsgSubscription.md)
 - [V2xMsgSubscriptionFilterCriteria](docs/V2xMsgSubscriptionFilterCriteria.md)
 - [V2xServerUsd](docs/V2xServerUsd.md)
 - [V2xServerUsdSdpInfo](docs/V2xServerUsdSdpInfo.md)
 - [V2xServerUsdTmgi](docs/V2xServerUsdTmgi.md)
 - [WebsockNotifConfig](docs/WebsockNotifConfig.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com
